/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.qoi;

import java.io.IOException;
import java.io.InputStream;
import lombok.NonNull;
import me.saharnooby.qoi.InvalidQOIStreamException;
import me.saharnooby.qoi.QOICodec;
import me.saharnooby.qoi.QOIColorSpace;
import me.saharnooby.qoi.QOIImage;

public final class QOIDecoder {
    public static QOIImage decode(@NonNull InputStream inputStream, int channels) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        return QOIDecoder.decode(inputStream, channels, false);
    }

    public static QOIImage decode(@NonNull InputStream inputStream, int channels, boolean doNotTouchDataAfterImage) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (channels != 0 && channels != 3 && channels != 4) {
            throw new IllegalArgumentException("Invalid channel count, must be 0, 3 or 4");
        }
        Input in = new Input(inputStream, !doNotTouchDataAfterImage);
        int headerMagic = in.readInt();
        if (headerMagic != 1903126886) {
            throw new InvalidQOIStreamException("Invalid magic value, probably not a QOI image");
        }
        int width = in.readInt();
        if (width < 1) {
            throw new InvalidQOIStreamException("Invalid image width");
        }
        int height = in.readInt();
        if (height < 1) {
            throw new InvalidQOIStreamException("Invalid image height");
        }
        int storedChannels = in.read() & 0xFF;
        if (storedChannels != 3 && storedChannels != 4) {
            throw new InvalidQOIStreamException("Invalid stored channel count");
        }
        if (channels == 0) {
            channels = storedChannels;
        }
        QOIColorSpace colorSpace = in.readColorSpace();
        byte[] pixelData = channels == 3 ? QOIDecoder.read3(in, width, height) : QOIDecoder.read4(in, width, height);
        for (int i = 0; i < 8; ++i) {
            if (QOICodec.QOI_PADDING[i] == in.readSkipBuffer()) continue;
            throw new InvalidQOIStreamException("Invalid padding");
        }
        return new QOIImage(width, height, channels, colorSpace, pixelData);
    }

    private static byte[] read3(@NonNull Input in, int width, int height) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        int pixelDataLength = Math.multiplyExact(Math.multiplyExact(width, height), 3);
        byte[] pixelData = new byte[pixelDataLength];
        byte[] index = QOICodec.createHashTableRGBA();
        byte pixelR = 0;
        byte pixelG = 0;
        byte pixelB = 0;
        byte pixelA = -1;
        for (int pixelPos = 0; pixelPos < pixelDataLength; pixelPos += 3) {
            int indexPos;
            int b1 = in.read() & 0xFF;
            if (b1 == 254) {
                pixelR = in.read();
                pixelG = in.read();
                pixelB = in.read();
            } else if (b1 == 255) {
                pixelR = in.read();
                pixelG = in.read();
                pixelB = in.read();
                pixelA = in.read();
            } else {
                switch (b1 & 0xC0) {
                    case 0: {
                        indexPos = (b1 & 0xFFFFFF3F) << 2;
                        pixelR = index[indexPos];
                        pixelG = index[indexPos + 1];
                        pixelB = index[indexPos + 2];
                        pixelA = index[indexPos + 3];
                        break;
                    }
                    case 64: {
                        pixelR = (byte)(pixelR + ((b1 >> 4 & 3) - 2));
                        pixelG = (byte)(pixelG + ((b1 >> 2 & 3) - 2));
                        pixelB = (byte)(pixelB + ((b1 & 3) - 2));
                        break;
                    }
                    case 128: {
                        byte b2 = in.read();
                        int vg = (b1 & 0x3F) - 32;
                        pixelR = (byte)(pixelR + (vg - 8 + (b2 >> 4 & 0xF)));
                        pixelG = (byte)(pixelG + vg);
                        pixelB = (byte)(pixelB + (vg - 8 + (b2 & 0xF)));
                        break;
                    }
                    case 192: {
                        int run = b1 & 0x3F;
                        for (int i = 0; i < run; ++i) {
                            pixelData[pixelPos] = pixelR;
                            pixelData[pixelPos + 1] = pixelG;
                            pixelData[pixelPos + 2] = pixelB;
                            pixelPos += 3;
                        }
                        break;
                    }
                }
            }
            indexPos = QOICodec.getHashTableIndexRGBA(pixelR, pixelG, pixelB, pixelA);
            index[indexPos] = pixelR;
            index[indexPos + 1] = pixelG;
            index[indexPos + 2] = pixelB;
            index[indexPos + 3] = pixelA;
            pixelData[pixelPos] = pixelR;
            pixelData[pixelPos + 1] = pixelG;
            pixelData[pixelPos + 2] = pixelB;
        }
        return pixelData;
    }

    private static byte[] read4(@NonNull Input in, int width, int height) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        int pixelDataLength = Math.multiplyExact(Math.multiplyExact(width, height), 4);
        byte[] pixelData = new byte[pixelDataLength];
        byte[] index = QOICodec.createHashTableRGBA();
        byte pixelR = 0;
        byte pixelG = 0;
        byte pixelB = 0;
        byte pixelA = -1;
        for (int pixelPos = 0; pixelPos < pixelDataLength; pixelPos += 4) {
            int indexPos;
            int b1 = in.read() & 0xFF;
            if (b1 == 254) {
                pixelR = in.read();
                pixelG = in.read();
                pixelB = in.read();
            } else if (b1 == 255) {
                pixelR = in.read();
                pixelG = in.read();
                pixelB = in.read();
                pixelA = in.read();
            } else {
                switch (b1 & 0xC0) {
                    case 0: {
                        indexPos = (b1 & 0xFFFFFF3F) << 2;
                        pixelR = index[indexPos];
                        pixelG = index[indexPos + 1];
                        pixelB = index[indexPos + 2];
                        pixelA = index[indexPos + 3];
                        break;
                    }
                    case 64: {
                        pixelR = (byte)(pixelR + ((b1 >> 4 & 3) - 2));
                        pixelG = (byte)(pixelG + ((b1 >> 2 & 3) - 2));
                        pixelB = (byte)(pixelB + ((b1 & 3) - 2));
                        break;
                    }
                    case 128: {
                        byte b2 = in.read();
                        int vg = (b1 & 0x3F) - 32;
                        pixelR = (byte)(pixelR + (vg - 8 + (b2 >> 4 & 0xF)));
                        pixelG = (byte)(pixelG + vg);
                        pixelB = (byte)(pixelB + (vg - 8 + (b2 & 0xF)));
                        break;
                    }
                    case 192: {
                        int run = b1 & 0x3F;
                        for (int i = 0; i < run; ++i) {
                            pixelData[pixelPos] = pixelR;
                            pixelData[pixelPos + 1] = pixelG;
                            pixelData[pixelPos + 2] = pixelB;
                            pixelData[pixelPos + 3] = pixelA;
                            pixelPos += 4;
                        }
                        break;
                    }
                }
            }
            indexPos = QOICodec.getHashTableIndexRGBA(pixelR, pixelG, pixelB, pixelA);
            index[indexPos] = pixelR;
            index[indexPos + 1] = pixelG;
            index[indexPos + 2] = pixelB;
            index[indexPos + 3] = pixelA;
            pixelData[pixelPos] = pixelR;
            pixelData[pixelPos + 1] = pixelG;
            pixelData[pixelPos + 2] = pixelB;
            pixelData[pixelPos + 3] = pixelA;
        }
        return pixelData;
    }

    private static final class Input {
        private static final int BUFFER_SIZE = 8192;
        private final InputStream in;
        private final byte[] buffer;
        private int position;
        private int read;

        private Input(@NonNull InputStream in, boolean useBuffer) {
            if (in == null) {
                throw new NullPointerException("in is marked non-null but is null");
            }
            this.in = in;
            this.buffer = useBuffer ? new byte[8192] : null;
        }

        public byte read() throws IOException {
            if (this.buffer == null) {
                return this.readSingleByte();
            }
            if (this.position == this.read) {
                this.read = this.in.read(this.buffer);
                if (this.read == -1) {
                    throw new InvalidQOIStreamException("Unexpected end of stream");
                }
                this.position = 0;
            }
            return this.buffer[this.position++];
        }

        public byte readSkipBuffer() throws IOException {
            if (this.buffer == null) {
                return this.readSingleByte();
            }
            if (this.position == this.read) {
                return this.readSingleByte();
            }
            return this.buffer[this.position++];
        }

        private byte readSingleByte() throws IOException {
            int read = this.in.read();
            if (read == -1) {
                throw new InvalidQOIStreamException("Unexpected end of stream");
            }
            return (byte)read;
        }

        public int readInt() throws IOException {
            int a = this.read() & 0xFF;
            int b = this.read() & 0xFF;
            int c = this.read() & 0xFF;
            int d = this.read() & 0xFF;
            return a << 24 | b << 16 | c << 8 | d;
        }

        public QOIColorSpace readColorSpace() throws IOException {
            int value = this.read() & 0xFF;
            switch (value) {
                case 0: {
                    return QOIColorSpace.SRGB;
                }
                case 1: {
                    return QOIColorSpace.LINEAR;
                }
            }
            throw new InvalidQOIStreamException("Invalid color space value " + value);
        }
    }
}

