/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.qoi;

import java.io.IOException;
import java.io.OutputStream;
import lombok.NonNull;
import me.saharnooby.qoi.QOICodec;
import me.saharnooby.qoi.QOIColorSpace;
import me.saharnooby.qoi.QOIImage;

public final class QOIEncoder {
    public static void encode(@NonNull QOIImage image, @NonNull OutputStream outputStream) throws IOException {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        int channels = image.getChannels();
        byte[] pixelData = image.getPixelData();
        Output out = new Output(outputStream);
        out.writeInt(1903126886);
        out.writeInt(image.getWidth());
        out.writeInt(image.getHeight());
        out.write(image.getChannels());
        out.writeColorSpace(image.getColorSpace());
        if (channels == 3) {
            QOIEncoder.encode3(out, pixelData);
        } else {
            QOIEncoder.encode4(out, pixelData);
        }
        for (byte b : QOICodec.QOI_PADDING) {
            out.write(b);
        }
        out.flush();
    }

    private static void encode3(@NonNull Output out, byte @NonNull [] pixelData) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        if (pixelData == null) {
            throw new NullPointerException("pixelData is marked non-null but is null");
        }
        byte[] index = QOICodec.createHashTableRGBA();
        int run = 0;
        byte prevR = 0;
        byte prevG = 0;
        byte prevB = 0;
        for (int pixelPos = 0; pixelPos < pixelData.length; pixelPos += 3) {
            int indexPos;
            byte pixelR = pixelData[pixelPos];
            byte pixelG = pixelData[pixelPos + 1];
            byte pixelB = pixelData[pixelPos + 2];
            if (QOIEncoder.equals(prevR, prevG, prevB, pixelR, pixelG, pixelB)) {
                if (++run != 62) continue;
                out.write(0xC0 | run - 1);
                run = 0;
                continue;
            }
            if (run > 0) {
                out.write(0xC0 | run - 1);
                run = 0;
            }
            if (QOIEncoder.equals(pixelR, pixelG, pixelB, (byte)-1, index[indexPos = QOICodec.getHashTableIndexRGB(pixelR, pixelG, pixelB)], index[indexPos + 1], index[indexPos + 2], index[indexPos + 3])) {
                out.write(0 | indexPos / 4);
            } else {
                index[indexPos] = pixelR;
                index[indexPos + 1] = pixelG;
                index[indexPos + 2] = pixelB;
                index[indexPos + 3] = -1;
                byte dr = (byte)(pixelR - prevR);
                byte dg = (byte)(pixelG - prevG);
                byte db = (byte)(pixelB - prevB);
                if (QOIEncoder.smallestDiff(dr) && QOIEncoder.smallestDiff(dg) && QOIEncoder.smallestDiff(db)) {
                    out.write(0x40 | dr + 2 << 4 | dg + 2 << 2 | db + 2);
                } else {
                    int dgr = dr - dg;
                    int dgb = db - dg;
                    if (QOIEncoder.smallerDiff(dgr) && QOIEncoder.smallDiff(dg) && QOIEncoder.smallerDiff(dgb)) {
                        out.write(0x80 | dg + 32);
                        out.write(dgr + 8 << 4 | dgb + 8);
                    } else {
                        out.write(254);
                        out.write(pixelR, pixelG, pixelB);
                    }
                }
            }
            prevR = pixelR;
            prevG = pixelG;
            prevB = pixelB;
        }
        if (run > 0) {
            out.write(0xC0 | run - 1);
        }
    }

    private static void encode4(@NonNull Output out, byte @NonNull [] pixelData) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        if (pixelData == null) {
            throw new NullPointerException("pixelData is marked non-null but is null");
        }
        byte[] index = QOICodec.createHashTableRGBA();
        int run = 0;
        byte prevR = 0;
        byte prevG = 0;
        byte prevB = 0;
        byte prevA = -1;
        for (int pixelPos = 0; pixelPos < pixelData.length; pixelPos += 4) {
            int indexPos;
            byte pixelR = pixelData[pixelPos];
            byte pixelG = pixelData[pixelPos + 1];
            byte pixelB = pixelData[pixelPos + 2];
            byte pixelA = pixelData[pixelPos + 3];
            if (QOIEncoder.equals(prevR, prevG, prevB, prevA, pixelR, pixelG, pixelB, pixelA)) {
                if (++run != 62) continue;
                out.write(0xC0 | run - 1);
                run = 0;
                continue;
            }
            if (run > 0) {
                out.write(0xC0 | run - 1);
                run = 0;
            }
            if (QOIEncoder.equals(pixelR, pixelG, pixelB, pixelA, index[indexPos = QOICodec.getHashTableIndexRGBA(pixelR, pixelG, pixelB, pixelA)], index[indexPos + 1], index[indexPos + 2], index[indexPos + 3])) {
                out.write(0 | indexPos / 4);
            } else {
                index[indexPos] = pixelR;
                index[indexPos + 1] = pixelG;
                index[indexPos + 2] = pixelB;
                index[indexPos + 3] = pixelA;
                if (prevA == pixelA) {
                    byte dr = (byte)(pixelR - prevR);
                    byte dg = (byte)(pixelG - prevG);
                    byte db = (byte)(pixelB - prevB);
                    if (QOIEncoder.smallestDiff(dr) && QOIEncoder.smallestDiff(dg) && QOIEncoder.smallestDiff(db)) {
                        out.write(0x40 | dr + 2 << 4 | dg + 2 << 2 | db + 2);
                    } else {
                        int dgr = dr - dg;
                        int dgb = db - dg;
                        if (QOIEncoder.smallerDiff(dgr) && QOIEncoder.smallDiff(dg) && QOIEncoder.smallerDiff(dgb)) {
                            out.write(0x80 | dg + 32);
                            out.write(dgr + 8 << 4 | dgb + 8);
                        } else {
                            out.write(254);
                            out.write(pixelR, pixelG, pixelB);
                        }
                    }
                } else {
                    out.write(255);
                    out.write(pixelR, pixelG, pixelB, pixelA);
                }
            }
            prevR = pixelR;
            prevG = pixelG;
            prevB = pixelB;
            prevA = pixelA;
        }
        if (run > 0) {
            out.write(0xC0 | run - 1);
        }
    }

    private static boolean smallDiff(int i) {
        return i > -33 && i < 32;
    }

    private static boolean smallerDiff(int i) {
        return i > -9 && i < 8;
    }

    private static boolean smallestDiff(int i) {
        return i > -3 && i < 2;
    }

    private static boolean equals(byte r1, byte g1, byte b1, byte a1, byte r2, byte g2, byte b2, byte a2) {
        return r1 == r2 && g1 == g2 && b1 == b2 && a1 == a2;
    }

    private static boolean equals(byte r1, byte g1, byte b1, byte r2, byte g2, byte b2) {
        return r1 == r2 && g1 == g2 && b1 == b2;
    }

    private static final class Output {
        private static final int BUFFER_SIZE = 8192;
        private final OutputStream out;
        private final byte[] buffer = new byte[8192];
        private int written;

        private Output(@NonNull OutputStream out) {
            if (out == null) {
                throw new NullPointerException("out is marked non-null but is null");
            }
            this.out = out;
        }

        public void write(byte value) throws IOException {
            if (this.written == 8192) {
                this.doFlush();
            }
            this.buffer[this.written++] = value;
        }

        public void write(int value) throws IOException {
            this.write((byte)value);
        }

        public void write(byte a, byte b, byte c) throws IOException {
            if (this.written > 8189) {
                this.doFlush();
            }
            this.buffer[this.written] = a;
            this.buffer[this.written + 1] = b;
            this.buffer[this.written + 2] = c;
            this.written += 3;
        }

        public void write(byte a, byte b, byte c, byte d) throws IOException {
            if (this.written > 8188) {
                this.doFlush();
            }
            this.buffer[this.written] = a;
            this.buffer[this.written + 1] = b;
            this.buffer[this.written + 2] = c;
            this.buffer[this.written + 3] = d;
            this.written += 4;
        }

        public void writeColorSpace(@NonNull QOIColorSpace colorSpace) throws IOException {
            if (colorSpace == null) {
                throw new NullPointerException("colorSpace is marked non-null but is null");
            }
            switch (colorSpace) {
                case SRGB: {
                    this.write(0);
                    break;
                }
                case LINEAR: {
                    this.write(1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported color space");
                }
            }
        }

        public void writeInt(int value) throws IOException {
            this.write(value >> 24);
            this.write(value >> 16);
            this.write(value >> 8);
            this.write(value);
        }

        public void flush() throws IOException {
            if (this.written == 0) {
                return;
            }
            this.doFlush();
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.written);
            this.written = 0;
        }
    }
}

