/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.excel;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.saro.commons.Converter;
import me.saro.commons.excel.BasicExcel;
import me.saro.commons.excel.ExcelCell;
import me.saro.commons.excel.ExcelRow;
import me.saro.commons.function.ThrowableFunction;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public interface Excel
extends Closeable {
    public static Excel createBulkExcel() {
        return new BasicExcel((Workbook)new SXSSFWorkbook(100));
    }

    public static Excel create() {
        return new BasicExcel((Workbook)new XSSFWorkbook());
    }

    public static Excel open(File file) throws IOException, InvalidFormatException {
        return new BasicExcel((Workbook)new XSSFWorkbook(file));
    }

    public boolean isBulk();

    public Sheet getPoiSheet();

    public Excel moveSheet(int var1);

    public Excel moveNextRow();

    public ExcelRow getRow();

    public ExcelRow getRow(int var1);

    public ExcelCell getCell(int var1, int var2);

    public Excel autoSizeColumn();

    public Excel autoSizeColumn(int var1);

    public Excel output(OutputStream var1) throws IOException;

    public Excel save(File var1, boolean var2) throws IOException;

    default public ExcelCell getCell(String columnName) {
        int[] rc = ExcelCell.toRowCellIndex(columnName);
        return this.getCell(rc[0], rc[1]);
    }

    default public Excel writeHorizontalList(String startColumnName, Collection<Object> values) {
        if (values != null) {
            ExcelCell cell = this.getCell(startColumnName);
            for (Object value : values) {
                cell = cell.set(value).getNextCell();
            }
        }
        return this;
    }

    default public Excel writeVerticalList(String startColumnName, Collection<Object> values) {
        if (values != null) {
            ExcelCell cell = this.getCell(startColumnName);
            for (Object value : values) {
                cell = cell.set(value).getNextRowCell();
            }
        }
        return this;
    }

    default public <T> Excel writeTable(String startColumnName, Collection<String> columnNames, List<T> list) {
        if (list != null) {
            int[] rc = ExcelCell.toRowCellIndex(startColumnName);
            ExcelRow row = this.getRow(rc[0]);
            for (T t : list) {
                ExcelCell cell = row.getCell(rc[1]);
                Map map = Converter.toMapByClass(t);
                for (String name : columnNames) {
                    cell = cell.set(map.get(name)).getNextCell();
                }
                row = row.getNextRow();
            }
        }
        return this;
    }

    default public <T> Excel writePivotTable(String startColumnName, Collection<String> columnNames, List<T> list) {
        if (list != null) {
            int[] rc = ExcelCell.toRowCellIndex(startColumnName);
            int ri = rc[0];
            int ci = rc[1];
            for (T t : list) {
                ExcelCell cell = this.getCell(ri, ci++);
                Map map = Converter.toMapByClass(t);
                for (String name : columnNames) {
                    cell = cell.set(map.get(name)).getNextRowCell();
                }
            }
        }
        return this;
    }

    default public <R> List<R> readTable(String startColumnName, int columnCount, ThrowableFunction<List<ExcelCell>, R> map) {
        return this.readTable(startColumnName, columnCount, 2000000, map);
    }

    default public <R> List<R> readTable(String startColumnName, int columnCount, int limitRowCount, ThrowableFunction<List<ExcelCell>, R> map) {
        int[] rc = ExcelCell.toRowCellIndex(startColumnName);
        int ri = rc[0];
        int eri = Math.min(ri + limitRowCount, this.getPoiSheet().getLastRowNum() + 1);
        int ci = rc[1];
        int eci = ci + columnCount;
        ArrayList<Object> rv = new ArrayList<Object>();
        while (ri < eri) {
            try {
                ExcelRow row = this.getRow(ri++);
                if (row.isEmpty()) continue;
                ArrayList<ExcelCell> list = new ArrayList<ExcelCell>(columnCount);
                for (int i = ci; i < eci; ++i) {
                    list.add(row.getCell(i));
                }
                Object r = map.apply(list);
                if (r == null) continue;
                rv.add(r);
            }
            catch (Exception e) {
                throw new RuntimeException("row[" + ExcelRow.toColumnNameByRowIndex(ri) + "] : " + e.getMessage(), e);
            }
        }
        return rv;
    }

    default public <R> List<R> readPivotTable(String startColumnName, int columnCount, ThrowableFunction<List<ExcelCell>, R> map) {
        return this.readPivotTable(startColumnName, columnCount, 10000, map);
    }

    default public <R> List<R> readPivotTable(String startColumnName, int columnCount, int limitRowCount, ThrowableFunction<List<ExcelCell>, R> map) {
        int[] rc = ExcelCell.toRowCellIndex(startColumnName);
        int ri = rc[0];
        int ci = rc[1];
        int eci = ci + limitRowCount;
        ExcelRow[] rows = new ExcelRow[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            rows[i] = this.getRow(ri + i);
            if (!rows[i].isEmpty()) continue;
            throw new IllegalArgumentException(ExcelCell.toColumnName(ri + i, ci) + " is does not exist");
        }
        ArrayList<Object> rv = new ArrayList<Object>();
        while (ci < eci) {
            try {
                int nullCnt = 0;
                ArrayList<ExcelCell> list = new ArrayList<ExcelCell>(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    ExcelCell cell = rows[i].getCell(ci);
                    if (cell.isEmpty()) {
                        ++nullCnt;
                    }
                    list.add(cell);
                }
                if (columnCount == nullCnt) break;
                ++ci;
                Object r = map.apply(list);
                if (r == null) continue;
                rv.add(r);
            }
            catch (Exception e) {
                throw new RuntimeException("column[" + ExcelCell.toColumnNameByCellIndex(ci) + "] : " + e.getMessage(), e);
            }
        }
        return rv;
    }
}

