/*
 * Decompiled with CFR 0.152.
 */
package me.saro.sap.jco;

import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoTable;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.saro.kit.functions.ThrowableBiConsumer;
import me.saro.sap.jco.SapUtils;

public class SapFunctionResult {
    final JCoFunction function;

    SapFunctionResult(JCoFunction function) {
        this.function = function;
    }

    public JCoParameterList getExportParameterList() {
        return this.function.getExportParameterList();
    }

    public int getTableCount() {
        return this.function.getTableParameterList().getFieldCount();
    }

    public JCoTable getJCoTable(int index) {
        return this.function.getTableParameterList().getTable(index);
    }

    public JCoTable getJCoTable(String name) {
        return this.function.getTableParameterList().getTable(name);
    }

    public List<Map<String, Object>> getTable(int index) {
        return SapUtils.toMapList(this.function.getTableParameterList().getTable(index));
    }

    public List<Map<String, Object>> getTable(String name) {
        return SapUtils.toMapList(this.function.getTableParameterList().getTable(name));
    }

    public <R> List<R> getTable(int index, Supplier<R> createRow, ThrowableBiConsumer<R, JCoField> bindField) {
        return SapUtils.toClass(this.function.getTableParameterList().getTable(index), createRow, bindField);
    }

    public <R> List<R> getTable(String name, Supplier<R> createRow, ThrowableBiConsumer<R, JCoField> bindField) {
        return SapUtils.toClass(this.function.getTableParameterList().getTable(name), createRow, bindField);
    }

    public List<List<Map<String, Object>>> getAllTables() {
        return IntStream.range(0, this.getTableCount()).mapToObj(e -> this.getTable(e)).collect(Collectors.toList());
    }
}

