/*
 * Decompiled with CFR 0.152.
 */
package me.saro.sap.jco;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import java.util.List;
import java.util.concurrent.ExecutorService;
import me.saro.kit.Threads;
import me.saro.kit.functions.ThrowableBiFunction;
import me.saro.sap.jco.SapFunction;

public class SapFunctionTemplate {
    final JCoDestination destination;
    final JCoFunctionTemplate jCoFunctionTemplate;

    SapFunctionTemplate(JCoDestination destination, JCoFunctionTemplate jCoFunctionTemplate) {
        this.destination = destination;
        this.jCoFunctionTemplate = jCoFunctionTemplate;
    }

    public SapFunction getFunction() {
        JCoFunction jCoFunction = this.jCoFunctionTemplate.getFunction();
        if (jCoFunction == null) {
            throw new RuntimeException("function `" + this.jCoFunctionTemplate.getName() + "` not found");
        }
        return new SapFunction(this.destination, jCoFunction);
    }

    public <T, R> List<R> executeAllThreads(int nThreads, List<T> list, ThrowableBiFunction<SapFunction, T, R> forEach) {
        return Threads.executeAllThreads((int)nThreads, list, e -> forEach.apply((Object)this.getFunction(), e));
    }

    public <T, R> List<R> executeAllThreads(ExecutorService executorService, List<T> list, ThrowableBiFunction<SapFunction, T, R> forEach) {
        return Threads.executeAllThreads((ExecutorService)executorService, list, e -> forEach.apply((Object)this.getFunction(), e));
    }
}

