/*
 * Decompiled with CFR 0.152.
 */
package me.saro.sap.jco;

import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import me.saro.sap.jco.SapManager;
import me.saro.sap.jco.SapManagerBuilderOption;

public class SapManagerBuilder {
    private final Properties properties = new Properties();

    SapManagerBuilder() {
    }

    public synchronized SapManager build() throws JCoException, IOException {
        return this.build("SAP");
    }

    public synchronized SapManager build(String createDestinationFileName) throws JCoException, IOException {
        File file = new File(createDestinationFileName + ".jcoDestination");
        if (file.exists()) {
            file.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(file, false);){
            this.properties.store(fos, "make connection file");
        }
        return new SapManager(JCoDestinationManager.getDestination((String)createDestinationFileName));
    }

    public SapManagerBuilder set(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public SapManagerBuilder set(SapManagerBuilderOption option, String value) {
        return this.set(option.value(), value);
    }
}

