/*
 * Decompiled with CFR 0.152.
 */
package me.saro.sap.jco;

import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoTable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.saro.kit.Streams;
import me.saro.kit.functions.ThrowableBiConsumer;
import me.saro.kit.functions.ThrowableConsumer;

public class SapUtils {
    private SapUtils() {
    }

    public static List<Map<String, Object>> toMapList(JCoTable table) {
        ArrayList<Map<String, Object>> rv = new ArrayList<Map<String, Object>>();
        if (!table.isEmpty()) {
            table.firstRow();
            do {
                LinkedHashMap map = new LinkedHashMap();
                Streams.toStream((Iterable)table, (boolean)false).forEach(field -> map.put(field.getName(), field.getValue()));
                rv.add(map);
            } while (table.nextRow());
        }
        return rv;
    }

    public static <R> List<R> toClass(JCoTable table, Supplier<R> createRow, ThrowableBiConsumer<R, JCoField> bindField) {
        ArrayList<R> rv = new ArrayList<R>();
        if (!table.isEmpty()) {
            table.firstRow();
            do {
                Object r = createRow.get();
                Streams.toStream((Iterable)table, (boolean)false).forEach(ThrowableConsumer.wrap(field -> bindField.accept(r, field)));
                rv.add(r);
            } while (table.nextRow());
        }
        return rv;
    }

    public static Object filterDate(Object value, String format) {
        if (value != null && "java.util.Date".equals(value.getClass().getName())) {
            return new SimpleDateFormat(format).format((Date)value);
        }
        return value;
    }
}

