/*
 * Decompiled with CFR 0.152.
 */
package sneerteam.api;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import sneerteam.api.ISubscriber;
import sneerteam.api.ISubscription;
import sneerteam.api.Value;

public interface ICloud
extends IInterface {
    public void pubPath(Value[] var1) throws RemoteException;

    public void pubValue(Value[] var1, Value var2) throws RemoteException;

    public ISubscription sub(Value[] var1, ISubscriber var2) throws RemoteException;

    public byte[] ownPublicKey() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICloud {
        private static final String DESCRIPTOR = "sneerteam.api.ICloud";
        static final int TRANSACTION_pubPath = 1;
        static final int TRANSACTION_pubValue = 2;
        static final int TRANSACTION_sub = 3;
        static final int TRANSACTION_ownPublicKey = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICloud asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICloud) {
                return (ICloud)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    Value[] _arg0 = (Value[])data.createTypedArray(Value.CREATOR);
                    this.pubPath(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    Value[] _arg0 = (Value[])data.createTypedArray(Value.CREATOR);
                    Value _arg1 = 0 != data.readInt() ? (Value)Value.CREATOR.createFromParcel(data) : null;
                    this.pubValue(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    Value[] _arg0 = (Value[])data.createTypedArray(Value.CREATOR);
                    ISubscriber _arg1 = ISubscriber.Stub.asInterface(data.readStrongBinder());
                    ISubscription _result = this.sub(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    byte[] _result = this.ownPublicKey();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements ICloud {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void pubPath(Value[] path) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray((Parcelable[])path, 0);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pubValue(Value[] path, Value value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray((Parcelable[])path, 0);
                    if (value != null) {
                        _data.writeInt(1);
                        value.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISubscription sub(Value[] path, ISubscriber subscriber) throws RemoteException {
                ISubscription _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray((Parcelable[])path, 0);
                    _data.writeStrongBinder(subscriber != null ? subscriber.asBinder() : null);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = ISubscription.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] ownPublicKey() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

