/*
 * Decompiled with CFR 0.152.
 */
package sneerteam.api;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.Map;
import us.bpsm.edn.Keyword;

public class Value
implements Parcelable {
    final Object value;
    public static final Parcelable.Creator<Value> CREATOR = new Parcelable.Creator<Value>(){

        public Value createFromParcel(Parcel in) {
            return Value.of(Value.read(in));
        }

        public Value[] newArray(int size) {
            return new Value[size];
        }
    };

    public static Value of(Object o) {
        return new Value(o);
    }

    Value(Object value) {
        this.value = value;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Value.write(dest, this.value);
    }

    public Object get() {
        return this.value;
    }

    public String toString() {
        return Type.of(this.value).name() + "(" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        return Value.equals(this.value, ((Value)o).value);
    }

    static boolean equals(Object x, Object y) {
        return x == y || x != null && y != null && x.equals(y);
    }

    static Object read(Parcel in) {
        Type type = Type.values()[in.readInt()];
        return type.createFromParcel(in);
    }

    static void write(Parcel dest, Object value) {
        Type t = Type.of(value);
        dest.writeInt(t.ordinal());
        t.writeToParcel(dest, value);
    }

    public static enum Type {
        NULL{

            @Override
            public Object createFromParcel(Parcel in) {
                return null;
            }

            @Override
            public void writeToParcel(Parcel dest, Object value) {
            }
        }
        ,
        STRING{

            @Override
            public Object createFromParcel(Parcel in) {
                return in.readString();
            }

            @Override
            public void writeToParcel(Parcel dest, Object value) {
                dest.writeString((String)value);
            }
        }
        ,
        KEYWORD{

            @Override
            public Object createFromParcel(Parcel in) {
                return Keyword.newKeyword((String)in.readString());
            }

            @Override
            public void writeToParcel(Parcel dest, Object value) {
                dest.writeString(((Keyword)value).getName());
            }
        }
        ,
        LONG{

            @Override
            public Object createFromParcel(Parcel in) {
                return in.readLong();
            }

            @Override
            public void writeToParcel(Parcel dest, Object value) {
                dest.writeLong(((Long)value).longValue());
            }
        }
        ,
        MAP{

            @Override
            public Object createFromParcel(Parcel in) {
                int size = in.readInt();
                HashMap<Object, Object> map = new HashMap<Object, Object>(size);
                for (int i = 0; i < size; ++i) {
                    map.put(Value.read(in), Value.read(in));
                }
                return map;
            }

            @Override
            public void writeToParcel(Parcel dest, Object value) {
                Map map = (Map)value;
                dest.writeInt(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    Value.write(dest, entry.getKey());
                    Value.write(dest, entry.getValue());
                }
            }
        };


        public static Type of(Object o) {
            if (o instanceof String) {
                return STRING;
            }
            if (o instanceof Long) {
                return LONG;
            }
            if (o instanceof Map) {
                return MAP;
            }
            if (o instanceof Keyword) {
                return KEYWORD;
            }
            return NULL;
        }

        public abstract Object createFromParcel(Parcel var1);

        public abstract void writeToParcel(Parcel var1, Object var2);
    }
}

