/*
 * Decompiled with CFR 0.152.
 */
package sneerteam.snapi;

import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.observables.ConnectableObservable;
import rx.schedulers.Schedulers;
import rx.subjects.ReplaySubject;
import sneerteam.snapi.CloudConnection;
import sneerteam.snapi.CloudPath;
import sneerteam.snapi.CloudServiceConnection;
import sneerteam.snapi.Contact;
import sneerteam.snapi.Path;
import sneerteam.snapi.PathEvent;

public class Cloud {
    private ReplaySubject<CloudConnection> eventualCloud = ReplaySubject.create();
    private Subscription subscription;

    public static Cloud cloudFor(Context context) {
        return Cloud.onScheduler(context, Schedulers.immediate());
    }

    public static Cloud onCurrentThread(Context context) {
        return Cloud.onScheduler(context, AndroidSchedulers.handlerThread((Handler)new Handler()));
    }

    public static Cloud onAndroidMainThread(Context context) {
        return Cloud.onScheduler(context, AndroidSchedulers.mainThread());
    }

    public static Cloud onScheduler(Context context, Scheduler scheduler) {
        return new Cloud((ConnectableObservable<CloudConnection>)CloudServiceConnection.cloudFor(context, scheduler).publish());
    }

    public Cloud(ConnectableObservable<CloudConnection> eventualCloud) {
        eventualCloud.subscribe(this.eventualCloud);
        this.subscription = eventualCloud.connect();
    }

    public void dispose() {
        this.subscription.unsubscribe();
    }

    public CloudPath path(Object ... segments) {
        return this.path(Arrays.asList(segments));
    }

    public CloudPath path(List<Object> list) {
        return new CloudPathImpl(list);
    }

    public Observable<byte[]> ownPublicKey() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<byte[]>(){

            public void call(final Subscriber<? super byte[]> subscriber) {
                Cloud.this.eventualCloud.subscribe((Action1)new Action1<CloudConnection>(){

                    public void call(CloudConnection cloud) {
                        try {
                            subscriber.onNext((Object)cloud.ownPublicKey());
                            subscriber.onCompleted();
                        }
                        catch (RemoteException e) {
                            subscriber.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    public Observable<Contact> contacts() {
        return this.contacts(CloudPath.ME);
    }

    Observable<Contact> contacts(Object root) {
        return this.path(root, "contacts").children().flatMap((Func1)new Func1<PathEvent, Observable<Contact>>(){

            public Observable<Contact> call(final PathEvent event) {
                return event.path().append("nickname").value().map((Func1)new Func1<Object, Contact>(){

                    public Contact call(Object nickname) {
                        return new Contact((String)event.path().lastSegment(), (String)nickname);
                    }
                });
            }
        });
    }

    private final class CloudPathImpl
    implements CloudPath {
        private List<Object> segments;

        public CloudPathImpl(List<Object> segments) {
            this.segments = segments;
        }

        @Override
        public Observable<PathEvent> children() {
            return Cloud.this.eventualCloud.flatMap((Func1)new Func1<CloudConnection, Observable<PathEvent>>(){

                public Observable<PathEvent> call(CloudConnection cloud) {
                    return cloud.path(CloudPathImpl.this.segments).children();
                }
            });
        }

        @Override
        public CloudPath append(Object segment) {
            return Cloud.this.path(Path.append(this.segments, segment));
        }

        @Override
        public void pub() {
            Cloud.this.eventualCloud.first().subscribe((Action1)new Action1<CloudConnection>(){

                public void call(CloudConnection cloud) {
                    cloud.path(CloudPathImpl.this.segments).pub();
                }
            });
        }

        @Override
        public void pub(final Object value) {
            Cloud.this.eventualCloud.first().subscribe((Action1)new Action1<CloudConnection>(){

                public void call(CloudConnection cloud) {
                    cloud.path(CloudPathImpl.this.segments).pub(value);
                }
            });
        }

        @Override
        public Observable<Object> value() {
            return Cloud.this.eventualCloud.flatMap((Func1)new Func1<CloudConnection, Observable<Object>>(){

                public Observable<Object> call(CloudConnection cloud) {
                    return cloud.path(CloudPathImpl.this.segments).value();
                }
            });
        }

        @Override
        public Observable<Boolean> exists(final long timeout, final TimeUnit unit) {
            return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

                public void call(final Subscriber<? super Boolean> subscriber) {
                    Cloud.this.eventualCloud.subscribe((Action1)new Action1<CloudConnection>(){

                        public void call(CloudConnection cloud) {
                            final Object token = new Object();
                            Observable.merge(cloud.path(CloudPathImpl.this.segments).value(), (Observable)Observable.from((Object)token).delay(timeout, unit)).first().observeOn(cloud.scheduler()).subscribe((Action1)new Action1<Object>(){

                                public void call(Object value) {
                                    subscriber.onNext((Object)(value != token ? 1 : 0));
                                    subscriber.onCompleted();
                                }
                            });
                        }
                    });
                }
            });
        }
    }
}

