/*
 * Decompiled with CFR 0.152.
 */
package sneerteam.snapi;

import android.os.IBinder;
import android.os.RemoteException;
import java.util.Arrays;
import java.util.List;
import rx.Scheduler;
import rx.schedulers.Schedulers;
import sneerteam.api.ICloud;
import sneerteam.api.ISubscriber;
import sneerteam.api.ISubscription;
import sneerteam.api.Value;
import sneerteam.snapi.Path;

public class CloudConnection {
    final ICloud cloud;
    final boolean remote;
    private Scheduler scheduler;

    public CloudConnection(ICloud cloud) {
        this(cloud, false, Schedulers.immediate());
    }

    public CloudConnection(IBinder binder, Scheduler scheduler) {
        this(ICloud.Stub.asInterface(binder), true, scheduler);
    }

    public CloudConnection(ICloud cloud, boolean remote, Scheduler scheduler) {
        this.cloud = cloud;
        this.remote = remote;
        this.scheduler = scheduler;
    }

    public Path path(Object ... segments) {
        return this.path(Arrays.asList(segments));
    }

    public Path path(List<Object> segments) {
        return new Path(this, segments);
    }

    ISubscription sub(Value[] path, ISubscriber subscriber) throws RemoteException {
        return this.cloud.sub(path, this.remote ? this.stub(subscriber) : subscriber);
    }

    ISubscriber stub(final ISubscriber subscriber) {
        return new ISubscriber.Stub(){

            @Override
            public void onValue(Value[] path, Value value) throws RemoteException {
                subscriber.onValue(path, value);
            }

            @Override
            public void onPath(Value[] path) throws RemoteException {
                subscriber.onPath(path);
            }
        };
    }

    public byte[] ownPublicKey() throws RemoteException {
        return this.cloud.ownPublicKey();
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }
}

