/*
 * Decompiled with CFR 0.152.
 */
package sneerteam.snapi;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.Schedulers;
import rx.subscriptions.Subscriptions;
import sneerteam.snapi.CloudConnection;
import sneerteam.snapi.SneerUtils;

public class CloudServiceConnection {
    public static Observable<CloudConnection> cloudFor(final Context context, final Scheduler scheduler) {
        if (context instanceof Activity) {
            SneerUtils.showSneerInstallationMessageIfNecessary((Activity)context);
        }
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<CloudConnection>(){

            public void call(final Subscriber<? super CloudConnection> subscriber) {
                Intent bindIntent = new Intent("sneerteam.intent.action.BIND_CLOUD_SERVICE");
                bindIntent.setClassName("sneerteam.android.main", "sneerteam.android.main.CloudService");
                final ServiceConnection serviceConnection = new ServiceConnection(){

                    public void onServiceConnected(ComponentName name, IBinder binder) {
                        subscriber.onNext((Object)new CloudConnection(binder, scheduler));
                    }

                    public void onServiceDisconnected(ComponentName arg0) {
                        subscriber.onCompleted();
                    }
                };
                context.bindService(bindIntent, serviceConnection, 1);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        context.unbindService(serviceConnection);
                    }
                }));
            }
        });
    }

    public static Observable<CloudConnection> cloudFor(Context context) {
        return CloudServiceConnection.cloudFor(context, Schedulers.immediate());
    }
}

