/*
 * Decompiled with CFR 0.152.
 */
package sneerteam.snapi;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import sneerteam.snapi.Contact;
import sneerteam.snapi.SneerUtils;

public class ContactPicker {
    public static Observable<Contact> pickContact(final Context context) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Contact>(){

            public void call(final Subscriber<? super Contact> subscriber) {
                Intent intent = new Intent("sneerteam.intent.action.PICK_CONTACT");
                intent.putExtra("result", (Parcelable)new ResultReceiver(null){

                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        subscriber.onNext((Object)new Contact(resultData.get("public_key").toString(), resultData.get("nickname").toString()));
                        subscriber.onCompleted();
                    }
                });
                try {
                    context.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    if (context instanceof Activity) {
                        SneerUtils.showSneerInstallationMessageIfNecessary((Activity)context);
                    }
                    Log.w((String)ContactPicker.class.getSimpleName(), (String)"Can't start contact picker", (Throwable)e);
                }
            }
        }).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread());
    }
}

