/*
 * Decompiled with CFR 0.152.
 */
package sneerteam.snapi;

import android.os.IBinder;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;
import sneerteam.api.ICloud;
import sneerteam.api.ISubscriber;
import sneerteam.api.ISubscription;
import sneerteam.api.Value;
import sneerteam.snapi.CloudConnection;
import sneerteam.snapi.Encoder;
import sneerteam.snapi.PathEvent;

public class Path {
    private final CloudConnection cloudConnection;
    private final List<Object> segments;

    Path(CloudConnection cloudConnection, List<Object> segments) {
        this.cloudConnection = cloudConnection;
        this.segments = segments;
    }

    public void pub() {
        try {
            this.cloud().pubPath(this.path());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void pub(Object value) {
        try {
            this.cloud().pubValue(this.path(), Value.of(value));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Path append(Object segment) {
        return new Path(this.cloudConnection, Path.append(this.segments, segment));
    }

    public Path prepend(Object segment) {
        return new Path(this.cloudConnection, Path.prepend(this.segments, segment));
    }

    public Observable<PathEvent> children() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<PathEvent>(){

            public void call(final Subscriber<? super PathEvent> subscriber) {
                try {
                    final ISubscription sub = Path.this.sub(new ISubscriber(){

                        @Override
                        public void onPath(final Value[] path) {
                            Path.this.cloudConnection.scheduler().schedule((Action1)new Action1<Scheduler.Inner>(){

                                public void call(Scheduler.Inner arg0) {
                                    subscriber.onNext((Object)new PathEvent(Path.this.cloudConnection.path(Encoder.pathDecode(path))));
                                }
                            });
                        }

                        @Override
                        public void onValue(Value[] path, Value value) {
                        }

                        public IBinder asBinder() {
                            return null;
                        }
                    });
                    if (sub != null) {
                        subscriber.add(Subscriptions.create((Action0)new Action0(){

                            public void call() {
                                try {
                                    sub.dispose();
                                }
                                catch (RemoteException e) {
                                    e.printStackTrace();
                                }
                            }
                        }));
                    }
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }

    public Subject<Object, Object> value() {
        return new Subject<Object, Object>((Observable.OnSubscribe)new Observable.OnSubscribe<Object>(){

            public void call(final Subscriber<? super Object> subscriber) {
                try {
                    final ISubscription sub = Path.this.sub(new ISubscriber(){

                        @Override
                        public void onPath(Value[] path) {
                        }

                        @Override
                        public void onValue(Value[] path, final Value value) {
                            Path.this.cloudConnection.scheduler().schedule((Action1)new Action1<Scheduler.Inner>(){

                                public void call(Scheduler.Inner arg0) {
                                    subscriber.onNext(value.get());
                                }
                            });
                        }

                        public IBinder asBinder() {
                            return null;
                        }
                    });
                    subscriber.add(Subscriptions.create((Action0)new Action0(){

                        public void call() {
                            try {
                                sub.dispose();
                            }
                            catch (RemoteException e) {
                                e.printStackTrace();
                            }
                        }
                    }));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    subscriber.onError((Throwable)e);
                }
            }
        }){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(Object value) {
                Path.this.pub(value);
            }
        };
    }

    private ISubscription sub(ISubscriber subscriber) throws RemoteException {
        return this.cloudConnection.sub(this.path(), subscriber);
    }

    private Value[] path() {
        return Encoder.pathEncode(this.segments);
    }

    private ICloud cloud() {
        return this.cloudConnection.cloud;
    }

    public static List<Object> append(List<Object> segments, Object segment) {
        ArrayList<Object> result = new ArrayList<Object>(segments.size() + 1);
        result.addAll(segments);
        result.add(segment);
        return result;
    }

    public static List<Object> prepend(List<Object> segments, Object segment) {
        ArrayList<Object> result = new ArrayList<Object>(segments.size() + 1);
        result.add(segment);
        result.addAll(segments);
        return result;
    }

    public Object lastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    public List<Object> segments() {
        return this.segments;
    }

    public Path parent() {
        return new Path(this.cloudConnection, this.segments.subList(0, this.segments.size() - 1));
    }
}

