/*
 * Decompiled with CFR 0.152.
 */
package me.sniggle.pgp.crypt;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import me.sniggle.pgp.crypt.internal.BaseKeyPairGenerator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGPKeyPairGenerator
extends BaseKeyPairGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPKeyPairGenerator.class);

    private PGPKeyRingGenerator createKeyRingGenerator(String userId, String password, int keySize) {
        LOGGER.trace("createKeyRingGenerator(String, String, int)");
        LOGGER.trace("User ID: {}, Password: {}, Key Size: {}", new Object[]{userId, password == null ? "not set" : "********", keySize});
        PGPKeyRingGenerator generator = null;
        try {
            LOGGER.debug("Creating RSA key pair generator");
            RSAKeyPairGenerator generator1 = new RSAKeyPairGenerator();
            generator1.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), this.getSecureRandom(), keySize, 12));
            LOGGER.debug("Generating Signing Key Pair");
            BcPGPKeyPair signingKeyPair = new BcPGPKeyPair(3, generator1.generateKeyPair(), new Date());
            LOGGER.debug("Generating Encyption Key Pair");
            BcPGPKeyPair encryptionKeyPair = new BcPGPKeyPair(2, generator1.generateKeyPair(), new Date());
            LOGGER.debug("Generating Signature Key Properties");
            PGPSignatureSubpacketGenerator signatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            signatureSubpacketGenerator.setKeyFlags(false, 3);
            signatureSubpacketGenerator.setPreferredSymmetricAlgorithms(false, this.getPreferredEncryptionAlgorithms());
            signatureSubpacketGenerator.setPreferredHashAlgorithms(false, this.getPreferredHashingAlgorithms());
            signatureSubpacketGenerator.setPreferredCompressionAlgorithms(false, this.getPreferredCompressionAlgorithms());
            LOGGER.debug("Generating Encyption Key Properties");
            PGPSignatureSubpacketGenerator encryptionSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            encryptionSubpacketGenerator.setKeyFlags(false, 12);
            LOGGER.info("Creating PGP Key Ring Generator");
            generator = new PGPKeyRingGenerator(3, (PGPKeyPair)signingKeyPair, userId, new BcPGPDigestCalculatorProvider().get(2), signatureSubpacketGenerator.generate(), null, (PGPContentSignerBuilder)new BcPGPContentSignerBuilder(3, 8), new BcPBESecretKeyEncryptorBuilder(this.getEncryptionAlgorithm()).build(password.toCharArray()));
            generator.addSubKey((PGPKeyPair)encryptionKeyPair, encryptionSubpacketGenerator.generate(), null);
        }
        catch (PGPException e) {
            LOGGER.error("{}", (Object)e.getMessage());
            generator = null;
        }
        return generator;
    }

    protected String getProvider() {
        return "BC";
    }

    public boolean generateKeyPair(String userId, String password, int keySize, OutputStream publicKey, OutputStream secrectKey) {
        Throwable throwable;
        ArmoredOutputStream targetStream;
        LOGGER.trace("generateKeyPair(String, String, int, OutputStream, OutputStream)");
        LOGGER.trace("User ID: {}, Password: {}, Key Size: {}, Public Key: {}, Secret Key: {}", new Object[]{userId, password == null ? "not set" : "********", keySize, publicKey == null ? "not set" : "set", secrectKey == null ? "not set" : "set"});
        boolean result = true;
        LOGGER.debug("Generating key ring generator");
        PGPKeyRingGenerator keyRingGenerator = this.createKeyRingGenerator(userId, password, keySize);
        LOGGER.debug("Generating public key ring");
        PGPPublicKeyRing publicKeyRing = keyRingGenerator.generatePublicKeyRing();
        LOGGER.debug("Generating secret key ring");
        PGPSecretKeyRing secretKeyRing = keyRingGenerator.generateSecretKeyRing();
        LOGGER.debug("Wrapping public key target stream in ArmoredOutputStream");
        try {
            targetStream = new ArmoredOutputStream(publicKey);
            throwable = null;
            try {
                LOGGER.info("Saving public key ring to public target");
                publicKeyRing.encode((OutputStream)targetStream);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (targetStream != null) {
                    if (throwable != null) {
                        try {
                            targetStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        targetStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("{}", (Object)e.getMessage());
            result &= false;
        }
        LOGGER.debug("Wrapping secret key target stream in ArmoredOutputStream");
        try {
            targetStream = new ArmoredOutputStream(secrectKey);
            throwable = null;
            try {
                LOGGER.debug("Create secret key ring collection");
                PGPSecretKeyRingCollection secretKeyRingCollection = new PGPSecretKeyRingCollection(Arrays.asList(secretKeyRing));
                LOGGER.info("Saving secret key ring to secret key target");
                secretKeyRingCollection.encode((OutputStream)targetStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (targetStream != null) {
                    if (throwable != null) {
                        try {
                            targetStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        targetStream.close();
                    }
                }
            }
        }
        catch (IOException | PGPException e) {
            LOGGER.error("{}", (Object)e.getMessage());
            result &= false;
        }
        return result;
    }
}

