/*
 * Decompiled with CFR 0.152.
 */
package me.sniggle.pgp.crypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import me.sniggle.pgp.crypt.MessageEncryptor;
import me.sniggle.pgp.crypt.internal.BasePGPCommon;
import me.sniggle.pgp.crypt.internal.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGPMessageEncryptor
extends BasePGPCommon
implements MessageEncryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPMessageEncryptor.class);

    private void encryptAndSign(PGPSecretKey pgpSecretKey, String password, String inputDataName, InputStream inputData, OutputStream encryptedDataStream) throws PGPException, IOException {
        LOGGER.trace("encryptAndSign(PGPSecretKey, String, String, InputStream, OutputStream)");
        LOGGER.trace("Secret Key: {}, Password: {}, Input Name: {}, Input Data: {}, Output Data: {}", new Object[]{pgpSecretKey == null ? "not set" : "set", password == null ? "not set" : "********", inputDataName, inputData == null ? "not set" : "set", encryptedDataStream == null ? "not set" : "set"});
        PGPSignatureGenerator pgpSignatureGenerator = null;
        PGPPrivateKey signingKey = null;
        if (pgpSecretKey != null) {
            LOGGER.info("Retrieving signing key from secret key");
            signingKey = this.findPrivateKey(pgpSecretKey, password);
        }
        LOGGER.debug("Wrapping target stream in compressed data stream");
        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(this.getCompressionAlgorithm());
        try (BCPGOutputStream compressedDataStream = new BCPGOutputStream(compressedDataGenerator.open(encryptedDataStream));){
            if (signingKey != null) {
                LOGGER.info("Preparing message signing");
                pgpSignatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(signingKey.getPublicKeyPacket().getAlgorithm(), 8));
                pgpSignatureGenerator.init(0, signingKey);
                pgpSignatureGenerator.generateOnePassVersion(false).encode((OutputStream)compressedDataStream);
            } else {
                LOGGER.info("No signing key provided. Encrypted data will be unsigned!");
            }
            PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator(false);
            LOGGER.debug("Wrapping compressed data stream in literal data stream");
            try (OutputStream literalDataOutputStream = literalDataGenerator.open((OutputStream)compressedDataStream, 'b', inputDataName, new Date(), new byte[4096]);){
                IOUtils.StreamHandler streamHandler = null;
                if (signingKey != null) {
                    final PGPSignatureGenerator callbackGenerator = pgpSignatureGenerator;
                    streamHandler = new IOUtils.StreamHandler(){

                        public void handleStreamBuffer(byte[] buffer, int offset, int length) throws IOException {
                            callbackGenerator.update(buffer, offset, length);
                        }
                    };
                }
                LOGGER.info("Encrypting data and saving to target stream");
                IOUtils.copy((InputStream)inputData, (OutputStream)literalDataOutputStream, (byte[])new byte[4096], (IOUtils.StreamHandler)streamHandler);
                literalDataGenerator.close();
            }
            if (signingKey != null) {
                LOGGER.info("Generating data signature");
                pgpSignatureGenerator.generate().encode((OutputStream)compressedDataStream);
            }
            compressedDataGenerator.close();
        }
    }

    protected int getEncryptionAlgorithm() {
        return this.isUnlimitedEncryptionStrength() ? 9 : 7;
    }

    public boolean encrypt(InputStream publicKeyOfRecipient, String inputDataName, InputStream plainInputData, OutputStream target) {
        LOGGER.trace("encrypt(InputStream, String, InputStream, OutputStream)");
        LOGGER.trace("Public Key: {}, Input Name: {}, Input Data: {}, Output: {}", new Object[]{publicKeyOfRecipient == null ? "not set" : "set", inputDataName, plainInputData == null ? "not set" : "set", target == null ? "not set" : "set"});
        return this.encrypt(publicKeyOfRecipient, null, null, null, inputDataName, plainInputData, target);
    }

    public boolean encrypt(InputStream publicKeyOfRecipient, InputStream privateKeyOfSender, String userIdOfSender, String passwordOfSendersPrivateKey, String inputDataName, InputStream plainInputData, OutputStream target) {
        LOGGER.trace("encrypt(InputStream, InputStream, String, String, String, InputStream, OutputStream)");
        LOGGER.trace("Public Key: {}, Private Key: {}, User ID: {}, Password: {}, Input Name: {}, Input Data: {}, Output: {}", new Object[]{publicKeyOfRecipient == null ? "not set" : "set", privateKeyOfSender == null ? "not set" : "set", userIdOfSender, passwordOfSendersPrivateKey == null ? "not set" : "********", inputDataName, plainInputData == null ? "not set" : "set", target == null ? "not set" : "set"});
        boolean result = true;
        LOGGER.debug("Reading public key");
        PGPPublicKey pgpPublicKey = this.findPublicKey(publicKeyOfRecipient, new BasePGPCommon.KeyFilter<PGPPublicKey>(){

            @Override
            public boolean accept(PGPPublicKey pgpKey) {
                return pgpKey.isEncryptionKey() && !pgpKey.isMasterKey();
            }
        });
        if (pgpPublicKey != null) {
            LOGGER.debug("Wrapping target stream in ArmoredOutputStream");
            try (ArmoredOutputStream wrappedTargetStream = new ArmoredOutputStream(target);){
                BcPGPDataEncryptorBuilder encryptorBuilder = new BcPGPDataEncryptorBuilder(this.getEncryptionAlgorithm());
                LOGGER.debug("Enabling integrity packet");
                encryptorBuilder.setWithIntegrityPacket(true);
                LOGGER.debug("Creating encrypted data generator");
                PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
                encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(pgpPublicKey));
                PGPSecretKey pgpSecretKey = null;
                if (privateKeyOfSender != null) {
                    LOGGER.debug("Looking up secret key");
                    pgpSecretKey = this.findSecretKey(privateKeyOfSender, userIdOfSender);
                } else {
                    LOGGER.info("No private key provided -> No signing of encrypted data");
                }
                LOGGER.debug("Wrapping target stream in encrypted output stream");
                try (OutputStream encryptedDataStream = encryptedDataGenerator.open((OutputStream)wrappedTargetStream, new byte[4096]);){
                    LOGGER.info("Encrypting and optionally signing of input data");
                    this.encryptAndSign(pgpSecretKey, passwordOfSendersPrivateKey, inputDataName, plainInputData, encryptedDataStream);
                }
            }
            catch (IOException | PGPException e) {
                LOGGER.error("{}", (Object)e.getMessage());
                result &= false;
            }
        } else {
            LOGGER.error("No public key found for encryption!");
            result &= false;
        }
        return result;
    }

    public boolean decrypt(String passwordOfReceiversPrivateKey, InputStream privateKeyOfReceiver, InputStream encryptedData, OutputStream target) {
        LOGGER.trace("decrypt(String, InputStream, InputStream, OutputStream)");
        LOGGER.trace("Password: {}, Private Key: {}, Encrypted Data: {}, Output: {}", new Object[]{passwordOfReceiversPrivateKey == null ? "not set" : "********", privateKeyOfReceiver == null ? "not set" : "set", encryptedData == null ? "not set" : "set", target == null ? "not set" : "set"});
        return this.decrypt(passwordOfReceiversPrivateKey, privateKeyOfReceiver, null, encryptedData, target);
    }

    public boolean decrypt(String passwordOfReceiversPrivateKey, InputStream privateKeyOfReceiver, InputStream publicKeyOfSender, InputStream encryptedData, OutputStream target) {
        LOGGER.trace("decrypt(String, InputStream, InputStream, InputStream, OutputStream)");
        LOGGER.trace("Password: {}, Private Key: {}, Public Key: {}, Encrypted Data: {}, Output: {}", new Object[]{passwordOfReceiversPrivateKey == null ? "not set" : "set", privateKeyOfReceiver == null ? "not set" : "set", publicKeyOfSender == null ? "not set" : "set", encryptedData == null ? "not set" : "set", target == null ? "not set" : "set"});
        boolean result = true;
        try {
            Throwable throwable;
            PGPPublicKeyRingCollection publicKeyRingCollection = null;
            if (publicKeyOfSender != null) {
                LOGGER.debug("Wrapping public key in ArmoredInputStream");
                throwable = null;
                try (ArmoredInputStream armoredInputStream = new ArmoredInputStream(publicKeyOfSender);){
                    publicKeyRingCollection = new PGPPublicKeyRingCollection((InputStream)armoredInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            LOGGER.debug("Retrieving DecoderStream from encrypted input");
            throwable = null;
            try (InputStream in = PGPUtil.getDecoderStream((InputStream)encryptedData);){
                LOGGER.debug("Create PGP Object factory");
                PGPObjectFactory objectFactory = new PGPObjectFactory(in, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                LOGGER.debug("Retrieve EncryptedDataList");
                Object firstObject = objectFactory.nextObject();
                PGPEncryptedDataList dataList = firstObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)firstObject : (PGPEncryptedDataList)objectFactory.nextObject();
                PGPPrivateKey pgpPrivateKey = null;
                PGPEncryptedData pgpEncryptedData = null;
                LOGGER.debug("Iterating over encrypted data objects");
                Iterator iterator = dataList.getEncryptedDataObjects();
                while (pgpPrivateKey == null && iterator.hasNext()) {
                    pgpEncryptedData = (PGPEncryptedData)iterator.next();
                    LOGGER.debug("Looking up private key");
                    pgpPrivateKey = this.findPrivateKey(privateKeyOfReceiver, ((PGPPublicKeyEncryptedData)pgpEncryptedData).getKeyID(), passwordOfReceiversPrivateKey);
                }
                BcPublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory = new BcPublicKeyDataDecryptorFactory(pgpPrivateKey);
                LOGGER.debug("Retrieving data stream from encrypted data");
                try (InputStream clearText = ((PGPPublicKeyEncryptedData)pgpEncryptedData).getDataStream((PublicKeyDataDecryptorFactory)publicKeyDataDecryptorFactory);){
                    Object message;
                    PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(clearText, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                    PGPOnePassSignatureList onePassSignatureList = null;
                    PGPOnePassSignature onePassSignature = null;
                    PGPSignatureList signatures = null;
                    PGPPublicKey pgpPublicKey = null;
                    while ((message = pgpObjectFactory.nextObject()) != null) {
                        if (message instanceof PGPCompressedData) {
                            PGPCompressedData compressedData = (PGPCompressedData)message;
                            LOGGER.debug("Compressed data block found, creating new object factory with compressed data stream");
                            pgpObjectFactory = new PGPObjectFactory(compressedData.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                        }
                        if (message instanceof PGPLiteralData) {
                            PGPLiteralData literalData = (PGPLiteralData)message;
                            LOGGER.debug("Reading literal data stream");
                            InputStream literalDataStream = literalData.getInputStream();
                            Throwable throwable2 = null;
                            try {
                                IOUtils.StreamHandler streamHandler = null;
                                if (onePassSignature != null) {
                                    final PGPOnePassSignature callbackSignature = onePassSignature;
                                    streamHandler = new IOUtils.StreamHandler(){

                                        public void handleStreamBuffer(byte[] buffer, int offset, int length) throws IOException {
                                            callbackSignature.update(buffer, offset, length);
                                        }
                                    };
                                }
                                IOUtils.copy((InputStream)literalDataStream, (OutputStream)target, (byte[])new byte[4096], streamHandler);
                                continue;
                            }
                            catch (Throwable x2) {
                                throwable2 = x2;
                                throw x2;
                            }
                            finally {
                                if (literalDataStream == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        literalDataStream.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable2.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                literalDataStream.close();
                                continue;
                            }
                        }
                        if (message instanceof PGPOnePassSignatureList) {
                            onePassSignatureList = (PGPOnePassSignatureList)message;
                            if (publicKeyOfSender == null) continue;
                            LOGGER.info("Public key provided -> verifying message signature");
                            onePassSignature = onePassSignatureList.get(0);
                            pgpPublicKey = publicKeyRingCollection.getPublicKey(onePassSignature.getKeyID());
                            onePassSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), pgpPublicKey);
                            continue;
                        }
                        if (!(message instanceof PGPSignatureList)) continue;
                        LOGGER.info("Signature List found for verification");
                        signatures = (PGPSignatureList)message;
                    }
                    LOGGER.debug("Iterating over signature list");
                    for (int i = 0; onePassSignatureList != null && i < onePassSignatureList.size(); ++i) {
                        if (pgpPublicKey == null || signatures == null) continue;
                        LOGGER.info("Verifying signatures");
                        PGPSignature signature = signatures.get(i);
                        if (onePassSignature.verify(signature)) {
                            LOGGER.info("Signature verified");
                            String userId = null;
                            Iterator it = pgpPublicKey.getUserIDs();
                            while (it.hasNext()) {
                                userId = (String)it.next();
                                LOGGER.info("Signed by {}", (Object)userId);
                            }
                            continue;
                        }
                        LOGGER.warn("Signature verification failed");
                        result &= false;
                    }
                    if (pgpEncryptedData.isIntegrityProtected()) {
                        LOGGER.info("Performing integrity check on encrypted data");
                        if (pgpEncryptedData.verify()) {
                            LOGGER.info("Data integrity verified");
                        } else {
                            LOGGER.warn("Data integrity verification failed");
                            result &= false;
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException | PGPException e) {
            LOGGER.error("{}", (Object)e.getMessage());
            result &= false;
        }
        return result;
    }
}

