/*
 * Decompiled with CFR 0.152.
 */
package me.sniggle.pgp.crypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import me.sniggle.pgp.crypt.MessageSigner;
import me.sniggle.pgp.crypt.internal.BasePGPCommon;
import me.sniggle.pgp.crypt.internal.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGPMessageSigner
extends BasePGPCommon
implements MessageSigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPMessageSigner.class);

    public boolean verifyMessage(InputStream publicKeyOfSender, InputStream message, InputStream signatureStream) {
        LOGGER.trace("verifyMessage(InputStream, InputStream, InputStream)");
        LOGGER.trace("Public Key: {}, Data: {}, Signature: {}", new Object[]{publicKeyOfSender == null ? "not set" : "set", message == null ? "not set" : "set", signatureStream == null ? "not set" : "set"});
        boolean result = false;
        LOGGER.debug("Wrapping signature stream in ArmoredInputStream");
        try (ArmoredInputStream armordPublicKeyStream = new ArmoredInputStream(signatureStream);){
            Object pgpObject;
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory((InputStream)armordPublicKeyStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            LOGGER.debug("Iterating over PGP objects in stream");
            while ((pgpObject = pgpObjectFactory.nextObject()) != null) {
                if (!(pgpObject instanceof PGPSignatureList)) continue;
                LOGGER.debug("Signature List found");
                PGPSignatureList signatureList = (PGPSignatureList)pgpObject;
                LOGGER.debug("Iterating over signature list");
                Iterator signatureIterator = signatureList.iterator();
                while (signatureIterator.hasNext()) {
                    LOGGER.debug("Checking next signature");
                    final PGPSignature signature = (PGPSignature)signatureIterator.next();
                    PGPPublicKey pgpPublicKey = this.findPublicKey(publicKeyOfSender, new BasePGPCommon.KeyFilter<PGPPublicKey>(){

                        @Override
                        public boolean accept(PGPPublicKey pgpKey) {
                            return pgpKey.getKeyID() == signature.getKeyID();
                        }
                    });
                    if (pgpPublicKey != null) {
                        signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), pgpPublicKey);
                        LOGGER.debug("Processing signature data");
                        IOUtils.process((InputStream)message, (IOUtils.StreamHandler)new IOUtils.StreamHandler(){

                            public void handleStreamBuffer(byte[] buffer, int offset, int length) throws IOException {
                                signature.update(buffer, offset, length);
                            }
                        });
                        result = signature.verify();
                        LOGGER.info("Verify Signature: {}", (Object)result);
                        continue;
                    }
                    LOGGER.warn("No public key found for signature. Key ID: {}", (Object)signature.getKeyID());
                }
            }
        }
        catch (IOException | PGPException e) {
            LOGGER.error("{}", (Object)e.getMessage());
            result &= false;
        }
        return result;
    }

    public boolean signMessage(InputStream privateKeyOfSender, final String userIdForPrivateKey, String passwordOfPrivateKey, InputStream message, OutputStream signature) {
        LOGGER.trace("signMessage(InputStream, String, String, InputStream, OutputStream)");
        LOGGER.trace("Private Key: {}, User ID: {}, Password: {}, Data: {}, Signature: {}", new Object[]{privateKeyOfSender == null ? "not set" : "set", userIdForPrivateKey, passwordOfPrivateKey == null ? "not set" : "********", message == null ? "not set" : "set", signature == null ? "not set" : "set"});
        boolean result = false;
        try {
            LOGGER.debug("Retrieving Private Key");
            PGPPrivateKey privateKey = this.findPrivateKey(privateKeyOfSender, passwordOfPrivateKey, new BasePGPCommon.KeyFilter<PGPSecretKey>(){

                @Override
                public boolean accept(PGPSecretKey secretKey) {
                    boolean result = secretKey.isSigningKey();
                    if (result) {
                        Iterator userIdIterator = secretKey.getUserIDs();
                        for (boolean containsUserId = false; userIdIterator.hasNext() && !containsUserId; containsUserId |= userIdForPrivateKey.equals(userIdIterator.next())) {
                        }
                    }
                    return result;
                }
            });
            LOGGER.debug("Initializing signature generator");
            final PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(privateKey.getPublicKeyPacket().getAlgorithm(), 8));
            signatureGenerator.init(0, privateKey);
            LOGGER.debug("Wrapping signature stream in ArmoredOutputStream and PGOutputStream");
            try (BCPGOutputStream outputStream = new BCPGOutputStream((OutputStream)new ArmoredOutputStream(signature));){
                IOUtils.process((InputStream)message, (IOUtils.StreamHandler)new IOUtils.StreamHandler(){

                    public void handleStreamBuffer(byte[] buffer, int offset, int length) throws IOException {
                        signatureGenerator.update(buffer, offset, length);
                    }
                });
                LOGGER.info("Writing signature out");
                signatureGenerator.generate().encode((OutputStream)outputStream);
            }
            result = true;
        }
        catch (IOException | PGPException e) {
            result &= false;
            LOGGER.error("{}", (Object)e.getMessage());
        }
        return result;
    }
}

