/*
 * Decompiled with CFR 0.152.
 */
package me.sniggle.pgp.crypt.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Iterator;
import me.sniggle.pgp.crypt.internal.AlgorithmSelection;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePGPCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePGPCommon.class);
    private boolean unlimitedEncryptionStrength = false;
    private int compressionAlgorithm = AlgorithmSelection.getDefaultCompressionAlgorithm();

    protected BasePGPCommon() {
    }

    protected int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(int compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    protected PGPSecretKey retrieveSecretKey(PGPSecretKeyRingCollection secretKeyRingCollection, KeyFilter<PGPSecretKey> keyFilter) throws PGPException {
        LOGGER.trace("retrieveSecretKey(PGPSecretKeyRingCollection, KeyFilter<PGPSecretKey>)");
        LOGGER.trace("Secret KeyRing Collection: {}, Key Filter: {}", (Object)(secretKeyRingCollection == null ? "not set" : "set"), (Object)(keyFilter == null ? "not set" : "set"));
        PGPSecretKey result = null;
        Iterator secretKeyRingIterator = secretKeyRingCollection.getKeyRings();
        PGPSecretKeyRing secretKeyRing = null;
        LOGGER.debug("Iterating secret key ring");
        while (result == null && secretKeyRingIterator.hasNext()) {
            secretKeyRing = (PGPSecretKeyRing)secretKeyRingIterator.next();
            Iterator secretKeyIterator = secretKeyRing.getSecretKeys();
            LOGGER.debug("Iterating secret keys in key ring");
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
                LOGGER.info("Found secret key: {}", (Object)secretKey.getKeyID());
                LOGGER.debug("Checking secret key with filter");
                if (!keyFilter.accept(secretKey)) continue;
                LOGGER.info("Key {} selected from secret key ring");
                result = secretKey;
            }
        }
        return result;
    }

    protected PGPSecretKey findSecretKey(InputStream secretKey, final String userId) throws IOException, PGPException {
        LOGGER.trace("findSecretKey(InputStream, String)");
        LOGGER.trace("Secret Key: {}, User ID: {}", (Object)(secretKey == null ? "not set" : "set"), (Object)userId);
        return this.findSecretKey(secretKey, new KeyFilter<PGPSecretKey>(){

            @Override
            public boolean accept(PGPSecretKey secretKey) {
                boolean result;
                Iterator userIdIterator = secretKey.getUserIDs();
                for (result = false; userIdIterator.hasNext() && !result; result |= userId.equals(userIdIterator.next())) {
                }
                return result;
            }
        });
    }

    protected PGPSecretKey findSecretKey(InputStream secretKey, final long keyId) throws IOException, PGPException {
        LOGGER.trace("findSecretKey(InputStream, long)");
        LOGGER.trace("Secret Key: {}, Key ID: {}", (Object)(secretKey == null ? "not set" : "set"), (Object)keyId);
        return this.findSecretKey(secretKey, new KeyFilter<PGPSecretKey>(){

            @Override
            public boolean accept(PGPSecretKey secretKey) {
                return secretKey.getKeyID() == keyId;
            }
        });
    }

    protected PGPSecretKey findSecretKey(InputStream secretKey, KeyFilter<PGPSecretKey> keyFilter) throws IOException, PGPException {
        LOGGER.trace("findSecretKey(InputStream, KeyFilter<PGPSecretKey>)");
        PGPSecretKey result = null;
        LOGGER.debug("Wrapping secret key stream in ArmoredInputStream");
        try (ArmoredInputStream armoredSecretKey = new ArmoredInputStream(secretKey);){
            LOGGER.debug("Creating PGPSecretKeyRingCollection");
            PGPSecretKeyRingCollection keyRingCollection = new PGPSecretKeyRingCollection((InputStream)armoredSecretKey, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            result = this.retrieveSecretKey(keyRingCollection, keyFilter);
        }
        return result;
    }

    protected PGPPrivateKey findPrivateKey(InputStream secretKey, final String userId, String password) throws PGPException, IOException {
        LOGGER.trace("findPrivateKey(InputStream, String, String)");
        LOGGER.trace("Secret Key: {}, User ID: {}, Password: {}", new Object[]{secretKey == null ? "not set" : "set", userId, password == null ? "not set" : "********"});
        return this.findPrivateKey(secretKey, password, new KeyFilter<PGPSecretKey>(){

            @Override
            public boolean accept(PGPSecretKey secretKey) {
                boolean result = false;
                Iterator userIdIterator = secretKey.getUserIDs();
                while (!result && userIdIterator.hasNext()) {
                    result = userId.equals(userIdIterator.next());
                }
                return result;
            }
        });
    }

    protected PGPPrivateKey findPrivateKey(InputStream secretKey, final long keyId, String password) throws PGPException, IOException {
        LOGGER.trace("findPrivateKey(InputStream, long, String)");
        LOGGER.trace("Secret Key: {}, Key ID: {}, Password: {}", new Object[]{secretKey == null ? "not set" : "set", keyId, password == null ? "not set" : "********"});
        return this.findPrivateKey(secretKey, password, new KeyFilter<PGPSecretKey>(){

            @Override
            public boolean accept(PGPSecretKey secretKey) {
                return secretKey.getKeyID() == keyId;
            }
        });
    }

    protected PGPPrivateKey findPrivateKey(InputStream secretKey, String password, KeyFilter<PGPSecretKey> keyFilter) throws IOException, PGPException {
        LOGGER.trace("findPrivateKey(InputStream, String, KeyFilter<PGPSecretKey>)");
        LOGGER.trace("Secret Key: {}, Password: {}, KeyFilter: {}", new Object[]{secretKey == null ? "not set" : "set", password == null ? "not set" : "********", keyFilter == null ? "not set" : "set"});
        return this.findPrivateKey(this.findSecretKey(secretKey, keyFilter), password);
    }

    protected PGPPrivateKey findPrivateKey(PGPSecretKey pgpSecretKey, String password) throws PGPException {
        LOGGER.trace("findPrivateKey(PGPSecretKey, String)");
        LOGGER.trace("Secret Key: {}, Password: {}", (Object)(pgpSecretKey == null ? "not set" : "set"), (Object)(password == null ? "not set" : "********"));
        PGPPrivateKey result = null;
        PBESecretKeyDecryptor pbeSecretKeyDecryptor = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(password.toCharArray());
        LOGGER.info("Extracting private key");
        result = pgpSecretKey.extractPrivateKey(pbeSecretKeyDecryptor);
        if (result == null && LOGGER.isErrorEnabled()) {
            LOGGER.error("No private key could be extracted");
        }
        return result;
    }

    protected PGPPublicKey findPublicKey(InputStream publicKey, KeyFilter<PGPPublicKey> keyFilter) {
        LOGGER.trace("findPublicKey(InputStream, KeyFilter<PGPPublicKey>)");
        LOGGER.trace("Public Key: {}, Key Filter: {}", (Object)(publicKey == null ? "not set" : "set"), (Object)(keyFilter == null ? "not set" : "set"));
        return this.retrievePublicKey(this.readPublicKeyRing(publicKey), keyFilter);
    }

    protected PGPPublicKey retrievePublicKey(PGPPublicKeyRing publicKeyRing, KeyFilter<PGPPublicKey> keyFilter) {
        LOGGER.trace("retrievePublicKey(PGPPublicKeyRing, KeyFilter<PGPPublicKey>)");
        PGPPublicKey result = null;
        Iterator publicKeyIterator = publicKeyRing.getPublicKeys();
        LOGGER.debug("Iterating through public keys in public key ring");
        while (result == null && publicKeyIterator.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)publicKeyIterator.next();
            LOGGER.info("Found secret key: {}", (Object)key.getKeyID());
            LOGGER.debug("Checking public key with filter");
            if (!keyFilter.accept(key)) continue;
            LOGGER.info("Public key {} selected from key ring", (Object)key.getKeyID());
            result = key;
        }
        return result;
    }

    protected PGPPublicKeyRing readPublicKeyRing(InputStream publicKey) {
        LOGGER.trace("readPublicKeyRing(InputStream)");
        PGPPublicKeyRing result = null;
        LOGGER.debug("Wrapping public key stream in decoder stream");
        try (InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)publicKey);){
            LOGGER.debug("Creating PGP Object Factory");
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            Object o = null;
            LOGGER.debug("Looking up PGP Public KeyRing");
            while ((o = pgpObjectFactory.nextObject()) != null && result == null) {
                if (!(o instanceof PGPPublicKeyRing)) continue;
                LOGGER.info("PGP Public KeyRing retrieved");
                result = (PGPPublicKeyRing)o;
            }
        }
        catch (IOException e) {
            LOGGER.error("{}", (Object)e.getMessage());
        }
        return result;
    }

    protected SecureRandom getSecureRandom() {
        return new SecureRandom();
    }

    public void setUnlimitedEncryptionStrength(boolean unlimitedEncryptionStrength) {
        this.unlimitedEncryptionStrength = unlimitedEncryptionStrength;
    }

    protected boolean isUnlimitedEncryptionStrength() {
        return this.unlimitedEncryptionStrength;
    }

    protected static interface KeyFilter<T> {
        public boolean accept(T var1);
    }
}

