/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.handler;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.DestinationRuleOperationImpl;

import me.snowdrop.istio.api.networking.v1alpha3.DestinationRule;
import me.snowdrop.istio.api.networking.v1alpha3.DestinationRuleBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class DestinationRuleHandler implements ResourceHandler<DestinationRule, DestinationRuleBuilder> {

  @Override
  public String getKind() {
    return DestinationRule.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "networking.istio.io/v1alpha3";
    }

  @Override
public DestinationRule create(OkHttpClient client, Config config, String namespace, DestinationRule item) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public DestinationRule replace(OkHttpClient client, Config config, String namespace, DestinationRule item) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public DestinationRule reload(OkHttpClient client, Config config, String namespace, DestinationRule item) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public DestinationRuleBuilder edit(DestinationRule item) {
return new DestinationRuleBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, DestinationRule item) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, DestinationRule item, Watcher<DestinationRule> watcher) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, DestinationRule item, String resourceVersion, Watcher<DestinationRule> watcher) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public DestinationRule waitUntilReady(OkHttpClient client, Config config, String namespace, DestinationRule item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public DestinationRule waitUntilCondition(OkHttpClient client, Config config, String namespace, DestinationRule item, Predicate<DestinationRule> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
