/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.handler;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.EdgeOperationImpl;

import me.snowdrop.istio.mixer.template.edge.Edge;
import me.snowdrop.istio.mixer.template.edge.EdgeBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class EdgeHandler implements ResourceHandler<Edge, EdgeBuilder> {

  @Override
  public String getKind() {
    return Edge.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.istio.io/v1alpha2";
    }

  @Override
public Edge create(OkHttpClient client, Config config, String namespace, Edge item) {
return new EdgeOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public Edge replace(OkHttpClient client, Config config, String namespace, Edge item) {
return new EdgeOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public Edge reload(OkHttpClient client, Config config, String namespace, Edge item) {
return new EdgeOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public EdgeBuilder edit(Edge item) {
return new EdgeBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Edge item) {
return new EdgeOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Edge item, Watcher<Edge> watcher) {
return new EdgeOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Edge item, String resourceVersion, Watcher<Edge> watcher) {
return new EdgeOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Edge waitUntilReady(OkHttpClient client, Config config, String namespace, Edge item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new EdgeOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public Edge waitUntilCondition(OkHttpClient client, Config config, String namespace, Edge item, Predicate<Edge> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EdgeOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
