/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.handler;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.MetricOperationImpl;

import me.snowdrop.istio.mixer.template.metric.Metric;
import me.snowdrop.istio.mixer.template.metric.MetricBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class MetricHandler implements ResourceHandler<Metric, MetricBuilder> {

  @Override
  public String getKind() {
    return Metric.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.istio.io/v1alpha2";
    }

  @Override
public Metric create(OkHttpClient client, Config config, String namespace, Metric item) {
return new MetricOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public Metric replace(OkHttpClient client, Config config, String namespace, Metric item) {
return new MetricOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public Metric reload(OkHttpClient client, Config config, String namespace, Metric item) {
return new MetricOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public MetricBuilder edit(Metric item) {
return new MetricBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Metric item) {
return new MetricOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Metric item, Watcher<Metric> watcher) {
return new MetricOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Metric item, String resourceVersion, Watcher<Metric> watcher) {
return new MetricOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Metric waitUntilReady(OkHttpClient client, Config config, String namespace, Metric item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new MetricOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public Metric waitUntilCondition(OkHttpClient client, Config config, String namespace, Metric item, Predicate<Metric> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MetricOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
