/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.handler;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.PolicyOperationImpl;

import me.snowdrop.istio.api.authentication.v1alpha1.Policy;
import me.snowdrop.istio.api.authentication.v1alpha1.PolicyBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class PolicyHandler implements ResourceHandler<Policy, PolicyBuilder> {

  @Override
  public String getKind() {
    return Policy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "authentication.istio.io/v1alpha1";
    }

  @Override
public Policy create(OkHttpClient client, Config config, String namespace, Policy item) {
return new PolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public Policy replace(OkHttpClient client, Config config, String namespace, Policy item) {
return new PolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public Policy reload(OkHttpClient client, Config config, String namespace, Policy item) {
return new PolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public PolicyBuilder edit(Policy item) {
return new PolicyBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Policy item) {
return new PolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Policy item, Watcher<Policy> watcher) {
return new PolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Policy item, String resourceVersion, Watcher<Policy> watcher) {
return new PolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Policy waitUntilReady(OkHttpClient client, Config config, String namespace, Policy item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new PolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public Policy waitUntilCondition(OkHttpClient client, Config config, String namespace, Policy item, Predicate<Policy> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
