/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.handler;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.RbacConfigOperationImpl;

import me.snowdrop.istio.api.rbac.v1alpha1.RbacConfig;
import me.snowdrop.istio.api.rbac.v1alpha1.RbacConfigBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class RbacConfigHandler implements ResourceHandler<RbacConfig, RbacConfigBuilder> {

  @Override
  public String getKind() {
    return RbacConfig.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "rbac.istio.io/v1alpha1";
    }

  @Override
public RbacConfig create(OkHttpClient client, Config config, String namespace, RbacConfig item) {
return new RbacConfigOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public RbacConfig replace(OkHttpClient client, Config config, String namespace, RbacConfig item) {
return new RbacConfigOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public RbacConfig reload(OkHttpClient client, Config config, String namespace, RbacConfig item) {
return new RbacConfigOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public RbacConfigBuilder edit(RbacConfig item) {
return new RbacConfigBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, RbacConfig item) {
return new RbacConfigOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, RbacConfig item, Watcher<RbacConfig> watcher) {
return new RbacConfigOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, RbacConfig item, String resourceVersion, Watcher<RbacConfig> watcher) {
return new RbacConfigOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public RbacConfig waitUntilReady(OkHttpClient client, Config config, String namespace, RbacConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new RbacConfigOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public RbacConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, RbacConfig item, Predicate<RbacConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RbacConfigOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
