/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.handler;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.RedisquotaOperationImpl;

import me.snowdrop.istio.mixer.adapter.redisquota.Redisquota;
import me.snowdrop.istio.mixer.adapter.redisquota.RedisquotaBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class RedisquotaHandler implements ResourceHandler<Redisquota, RedisquotaBuilder> {

  @Override
  public String getKind() {
    return Redisquota.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.istio.io/v1alpha2";
    }

  @Override
public Redisquota create(OkHttpClient client, Config config, String namespace, Redisquota item) {
return new RedisquotaOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public Redisquota replace(OkHttpClient client, Config config, String namespace, Redisquota item) {
return new RedisquotaOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public Redisquota reload(OkHttpClient client, Config config, String namespace, Redisquota item) {
return new RedisquotaOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public RedisquotaBuilder edit(Redisquota item) {
return new RedisquotaBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Redisquota item) {
return new RedisquotaOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Redisquota item, Watcher<Redisquota> watcher) {
return new RedisquotaOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Redisquota item, String resourceVersion, Watcher<Redisquota> watcher) {
return new RedisquotaOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Redisquota waitUntilReady(OkHttpClient client, Config config, String namespace, Redisquota item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new RedisquotaOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public Redisquota waitUntilCondition(OkHttpClient client, Config config, String namespace, Redisquota item, Predicate<Redisquota> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RedisquotaOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
