/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.handler;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.RuleOperationImpl;

import me.snowdrop.istio.api.policy.v1beta1.Rule;
import me.snowdrop.istio.api.policy.v1beta1.RuleBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class RuleHandler implements ResourceHandler<Rule, RuleBuilder> {

  @Override
  public String getKind() {
    return Rule.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.istio.io/v1alpha2";
    }

  @Override
public Rule create(OkHttpClient client, Config config, String namespace, Rule item) {
return new RuleOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public Rule replace(OkHttpClient client, Config config, String namespace, Rule item) {
return new RuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public Rule reload(OkHttpClient client, Config config, String namespace, Rule item) {
return new RuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public RuleBuilder edit(Rule item) {
return new RuleBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Rule item) {
return new RuleOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Rule item, Watcher<Rule> watcher) {
return new RuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Rule item, String resourceVersion, Watcher<Rule> watcher) {
return new RuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Rule waitUntilReady(OkHttpClient client, Config config, String namespace, Rule item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new RuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public Rule waitUntilCondition(OkHttpClient client, Config config, String namespace, Rule item, Predicate<Rule> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
