/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.operation;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.mixer.template.apikey.DoneableApiKey;
import me.snowdrop.istio.mixer.template.apikey.ApiKey;
import me.snowdrop.istio.mixer.template.apikey.ApiKeyList;
import me.snowdrop.istio.mixer.template.apikey.DoneableApiKey;

import java.util.Map;
import java.util.TreeMap;


public class ApiKeyOperationImpl extends HasMetadataOperation<ApiKey, ApiKeyList, DoneableApiKey, Resource<ApiKey, DoneableApiKey>> {

  public ApiKeyOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public ApiKeyOperationImpl(OperationContext context) {
    super(context.withApiGroupName("config.istio.io")
      .withApiGroupVersion("v1alpha2")
      .withPlural("apikeys"));
    this.type = ApiKey.class;
    this.listType = ApiKeyList.class;
    this.doneableType = DoneableApiKey.class;
}

  public ApiKeyOperationImpl newInstance(OperationContext context) {
    return new ApiKeyOperationImpl(context);
  }
}
