/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.operation;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.mixer.adapter.bypass.DoneableBypass;
import me.snowdrop.istio.mixer.adapter.bypass.Bypass;
import me.snowdrop.istio.mixer.adapter.bypass.BypassList;
import me.snowdrop.istio.mixer.adapter.bypass.DoneableBypass;

import java.util.Map;
import java.util.TreeMap;


public class BypassOperationImpl extends HasMetadataOperation<Bypass, BypassList, DoneableBypass, Resource<Bypass, DoneableBypass>> {

  public BypassOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public BypassOperationImpl(OperationContext context) {
    super(context.withApiGroupName("config.istio.io")
      .withApiGroupVersion("v1alpha2")
      .withPlural("bypasses"));
    this.type = Bypass.class;
    this.listType = BypassList.class;
    this.doneableType = DoneableBypass.class;
}

  public BypassOperationImpl newInstance(OperationContext context) {
    return new BypassOperationImpl(context);
  }
}
