/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.operation;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.mixer.adapter.solarwinds.DoneableSolarwinds;
import me.snowdrop.istio.mixer.adapter.solarwinds.Solarwinds;
import me.snowdrop.istio.mixer.adapter.solarwinds.SolarwindsList;
import me.snowdrop.istio.mixer.adapter.solarwinds.DoneableSolarwinds;

import java.util.Map;
import java.util.TreeMap;


public class SolarwindsOperationImpl extends HasMetadataOperation<Solarwinds, SolarwindsList, DoneableSolarwinds, Resource<Solarwinds, DoneableSolarwinds>> {

  public SolarwindsOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public SolarwindsOperationImpl(OperationContext context) {
    super(context.withApiGroupName("config.istio.io")
      .withApiGroupVersion("v1alpha2")
      .withPlural("solarwindses"));
    this.type = Solarwinds.class;
    this.listType = SolarwindsList.class;
    this.doneableType = DoneableSolarwinds.class;
}

  public SolarwindsOperationImpl newInstance(OperationContext context) {
    return new SolarwindsOperationImpl(context);
  }
}
