/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.client.internal.handler;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import me.snowdrop.istio.client.internal.operation.CloudwatchOperationImpl;
import me.snowdrop.istio.mixer.adapter.cloudwatch.Cloudwatch;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchBuilder;
import okhttp3.OkHttpClient;

public class CloudwatchHandler
implements ResourceHandler<Cloudwatch, CloudwatchBuilder> {
    public String getKind() {
        return Cloudwatch.class.getSimpleName();
    }

    public String getApiVersion() {
        return "config.istio.io/v1alpha2";
    }

    public Cloudwatch create(OkHttpClient client, Config config, String namespace, Cloudwatch item) {
        return (Cloudwatch)new CloudwatchOperationImpl(client, config).withItem(item).inNamespace(namespace).create((Object[])new Cloudwatch[0]);
    }

    public Cloudwatch replace(OkHttpClient client, Config config, String namespace, Cloudwatch item) {
        return (Cloudwatch)((Resource)new CloudwatchOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public Cloudwatch reload(OkHttpClient client, Config config, String namespace, Cloudwatch item) {
        return (Cloudwatch)((Gettable)((Resource)new CloudwatchOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public CloudwatchBuilder edit(Cloudwatch item) {
        return new CloudwatchBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Cloudwatch item) {
        return (Boolean)new CloudwatchOperationImpl(client, config).withItem(item).inNamespace(namespace).delete((Object[])new Cloudwatch[]{item});
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Cloudwatch item, Watcher<Cloudwatch> watcher) {
        return (Watch)((Resource)new CloudwatchOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Cloudwatch item, String resourceVersion, Watcher<Cloudwatch> watcher) {
        return (Watch)((Resource)new CloudwatchOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Cloudwatch waitUntilReady(OkHttpClient client, Config config, String namespace, Cloudwatch item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Cloudwatch)((Resource)new CloudwatchOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Cloudwatch waitUntilCondition(OkHttpClient client, Config config, String namespace, Cloudwatch item, Predicate<Cloudwatch> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Cloudwatch)((Resource)new CloudwatchOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

