
package me.snowdrop.istio.client.internal.handler.networking.v1alpha3;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.networking.v1alpha3.SidecarOperationImpl;

import me.snowdrop.istio.api.networking.v1alpha3.Sidecar;
import me.snowdrop.istio.api.networking.v1alpha3.SidecarBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class SidecarHandler implements ResourceHandler<Sidecar, SidecarBuilder> {

  @Override
  public String getKind() {
    return Sidecar.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "networking.istio.io/v1alpha3";
    }

  @Override
public Sidecar create(OkHttpClient client, Config config, String namespace, Sidecar item) {
return new SidecarOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public Sidecar replace(OkHttpClient client, Config config, String namespace, Sidecar item) {
return new SidecarOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public Sidecar reload(OkHttpClient client, Config config, String namespace, Sidecar item) {
return new SidecarOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public SidecarBuilder edit(Sidecar item) {
return new SidecarBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Sidecar item) {
return new SidecarOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Sidecar item, Watcher<Sidecar> watcher) {
return new SidecarOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Sidecar item, String resourceVersion, Watcher<Sidecar> watcher) {
return new SidecarOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Sidecar waitUntilReady(OkHttpClient client, Config config, String namespace, Sidecar item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new SidecarOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public Sidecar waitUntilCondition(OkHttpClient client, Config config, String namespace, Sidecar item, Predicate<Sidecar> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SidecarOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
