
package me.snowdrop.istio.client.internal.handler.networking.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.networking.v1beta1.ServiceEntryOperationImpl;

import me.snowdrop.istio.api.networking.v1beta1.ServiceEntry;
import me.snowdrop.istio.api.networking.v1beta1.ServiceEntryBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ServiceEntryHandler implements ResourceHandler<ServiceEntry, ServiceEntryBuilder> {

  @Override
  public String getKind() {
    return ServiceEntry.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "networking.istio.io/v1beta1";
    }

  @Override
public ServiceEntry create(OkHttpClient client, Config config, String namespace, ServiceEntry item) {
return new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public ServiceEntry replace(OkHttpClient client, Config config, String namespace, ServiceEntry item) {
return new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public ServiceEntry reload(OkHttpClient client, Config config, String namespace, ServiceEntry item) {
return new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public ServiceEntryBuilder edit(ServiceEntry item) {
return new ServiceEntryBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, ServiceEntry item) {
return new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, ServiceEntry item, Watcher<ServiceEntry> watcher) {
return new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, ServiceEntry item, String resourceVersion, Watcher<ServiceEntry> watcher) {
return new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public ServiceEntry waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceEntry item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public ServiceEntry waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceEntry item, Predicate<ServiceEntry> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
