
package me.snowdrop.istio.client.internal.handler.networking.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.networking.v1beta1.VirtualServiceOperationImpl;

import me.snowdrop.istio.api.networking.v1beta1.VirtualService;
import me.snowdrop.istio.api.networking.v1beta1.VirtualServiceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class VirtualServiceHandler implements ResourceHandler<VirtualService, VirtualServiceBuilder> {

  @Override
  public String getKind() {
    return VirtualService.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "networking.istio.io/v1beta1";
    }

  @Override
public VirtualService create(OkHttpClient client, Config config, String namespace, VirtualService item) {
return new VirtualServiceOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public VirtualService replace(OkHttpClient client, Config config, String namespace, VirtualService item) {
return new VirtualServiceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public VirtualService reload(OkHttpClient client, Config config, String namespace, VirtualService item) {
return new VirtualServiceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public VirtualServiceBuilder edit(VirtualService item) {
return new VirtualServiceBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, VirtualService item) {
return new VirtualServiceOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, VirtualService item, Watcher<VirtualService> watcher) {
return new VirtualServiceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, VirtualService item, String resourceVersion, Watcher<VirtualService> watcher) {
return new VirtualServiceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public VirtualService waitUntilReady(OkHttpClient client, Config config, String namespace, VirtualService item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new VirtualServiceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public VirtualService waitUntilCondition(OkHttpClient client, Config config, String namespace, VirtualService item, Predicate<VirtualService> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new VirtualServiceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
