
package me.snowdrop.istio.client.internal.handler.rbac.v1alpha1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.rbac.v1alpha1.ServiceRoleOperationImpl;

import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRole;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ServiceRoleHandler implements ResourceHandler<ServiceRole, ServiceRoleBuilder> {

  @Override
  public String getKind() {
    return ServiceRole.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "rbac.istio.io/v1alpha1";
    }

  @Override
public ServiceRole create(OkHttpClient client, Config config, String namespace, ServiceRole item) {
return new ServiceRoleOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public ServiceRole replace(OkHttpClient client, Config config, String namespace, ServiceRole item) {
return new ServiceRoleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public ServiceRole reload(OkHttpClient client, Config config, String namespace, ServiceRole item) {
return new ServiceRoleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public ServiceRoleBuilder edit(ServiceRole item) {
return new ServiceRoleBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, ServiceRole item) {
return new ServiceRoleOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, ServiceRole item, Watcher<ServiceRole> watcher) {
return new ServiceRoleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, ServiceRole item, String resourceVersion, Watcher<ServiceRole> watcher) {
return new ServiceRoleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public ServiceRole waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceRole item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new ServiceRoleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public ServiceRole waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceRole item, Predicate<ServiceRole> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceRoleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
