
package me.snowdrop.istio.client.internal.operation.authentication.v1alpha1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.api.authentication.v1alpha1.DoneablePolicy;
import me.snowdrop.istio.api.authentication.v1alpha1.Policy;
import me.snowdrop.istio.api.authentication.v1alpha1.PolicyList;
import me.snowdrop.istio.api.authentication.v1alpha1.DoneablePolicy;

import java.util.Map;
import java.util.TreeMap;


public class PolicyOperationImpl extends HasMetadataOperation<Policy, PolicyList, DoneablePolicy, Resource<Policy, DoneablePolicy>> {

  public PolicyOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public PolicyOperationImpl(OperationContext context) {
    super(context.withApiGroupName("authentication.istio.io")
      .withApiGroupVersion("v1alpha1")
      .withPlural("policies"));
    this.type = Policy.class;
    this.listType = PolicyList.class;
    this.doneableType = DoneablePolicy.class;
}

  public PolicyOperationImpl newInstance(OperationContext context) {
    return new PolicyOperationImpl(context);
  }
}
