
package me.snowdrop.istio.client.internal.operation.networking.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.api.networking.v1beta1.DoneableGateway;
import me.snowdrop.istio.api.networking.v1beta1.Gateway;
import me.snowdrop.istio.api.networking.v1beta1.GatewayList;
import me.snowdrop.istio.api.networking.v1beta1.DoneableGateway;

import java.util.Map;
import java.util.TreeMap;


public class GatewayOperationImpl extends HasMetadataOperation<Gateway, GatewayList, DoneableGateway, Resource<Gateway, DoneableGateway>> {

  public GatewayOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public GatewayOperationImpl(OperationContext context) {
    super(context.withApiGroupName("networking.istio.io")
      .withApiGroupVersion("v1beta1")
      .withPlural("gateways"));
    this.type = Gateway.class;
    this.listType = GatewayList.class;
    this.doneableType = DoneableGateway.class;
}

  public GatewayOperationImpl newInstance(OperationContext context) {
    return new GatewayOperationImpl(context);
  }
}
