
package me.snowdrop.istio.client.internal.operation.rbac.v1alpha1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.api.rbac.v1alpha1.DoneableServiceRoleBinding;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBinding;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBindingList;
import me.snowdrop.istio.api.rbac.v1alpha1.DoneableServiceRoleBinding;

import java.util.Map;
import java.util.TreeMap;


public class ServiceRoleBindingOperationImpl extends HasMetadataOperation<ServiceRoleBinding, ServiceRoleBindingList, DoneableServiceRoleBinding, Resource<ServiceRoleBinding, DoneableServiceRoleBinding>> {

  public ServiceRoleBindingOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public ServiceRoleBindingOperationImpl(OperationContext context) {
    super(context.withApiGroupName("rbac.istio.io")
      .withApiGroupVersion("v1alpha1")
      .withPlural("servicerolebindings"));
    this.type = ServiceRoleBinding.class;
    this.listType = ServiceRoleBindingList.class;
    this.doneableType = DoneableServiceRoleBinding.class;
}

  public ServiceRoleBindingOperationImpl newInstance(OperationContext context) {
    return new ServiceRoleBindingOperationImpl(context);
  }
}
