
package me.snowdrop.istio.client.internal.handler.networking.v1alpha3;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.networking.v1alpha3.EnvoyFilterOperationImpl;

import me.snowdrop.istio.api.networking.v1alpha3.EnvoyFilter;
import me.snowdrop.istio.api.networking.v1alpha3.EnvoyFilterBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class EnvoyFilterHandler implements ResourceHandler<EnvoyFilter, EnvoyFilterBuilder> {

  @Override
  public String getKind() {
    return EnvoyFilter.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "networking.istio.io/v1alpha3";
    }

  @Override
public EnvoyFilter create(OkHttpClient client, Config config, String namespace, EnvoyFilter item) {
return new EnvoyFilterOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public EnvoyFilter replace(OkHttpClient client, Config config, String namespace, EnvoyFilter item) {
return new EnvoyFilterOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public EnvoyFilter reload(OkHttpClient client, Config config, String namespace, EnvoyFilter item) {
return new EnvoyFilterOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public EnvoyFilterBuilder edit(EnvoyFilter item) {
return new EnvoyFilterBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, EnvoyFilter item) {
return new EnvoyFilterOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, EnvoyFilter item, Watcher<EnvoyFilter> watcher) {
return new EnvoyFilterOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, EnvoyFilter item, String resourceVersion, Watcher<EnvoyFilter> watcher) {
return new EnvoyFilterOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, EnvoyFilter item, ListOptions listOptions, final Watcher<EnvoyFilter> watcher) {
return new EnvoyFilterOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public EnvoyFilter waitUntilReady(OkHttpClient client, Config config, String namespace, EnvoyFilter item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new EnvoyFilterOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public EnvoyFilter waitUntilCondition(OkHttpClient client, Config config, String namespace, EnvoyFilter item, Predicate<EnvoyFilter> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EnvoyFilterOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
