
package me.snowdrop.istio.client.internal.handler.rbac.v1alpha1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.rbac.v1alpha1.ServiceRoleBindingOperationImpl;

import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBinding;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBindingBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ServiceRoleBindingHandler implements ResourceHandler<ServiceRoleBinding, ServiceRoleBindingBuilder> {

  @Override
  public String getKind() {
    return ServiceRoleBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "rbac.istio.io/v1alpha1";
    }

  @Override
public ServiceRoleBinding create(OkHttpClient client, Config config, String namespace, ServiceRoleBinding item) {
return new ServiceRoleBindingOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public ServiceRoleBinding replace(OkHttpClient client, Config config, String namespace, ServiceRoleBinding item) {
return new ServiceRoleBindingOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public ServiceRoleBinding reload(OkHttpClient client, Config config, String namespace, ServiceRoleBinding item) {
return new ServiceRoleBindingOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public ServiceRoleBindingBuilder edit(ServiceRoleBinding item) {
return new ServiceRoleBindingBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ServiceRoleBinding item) {
return new ServiceRoleBindingOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, ServiceRoleBinding item, Watcher<ServiceRoleBinding> watcher) {
return new ServiceRoleBindingOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, ServiceRoleBinding item, String resourceVersion, Watcher<ServiceRoleBinding> watcher) {
return new ServiceRoleBindingOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, ServiceRoleBinding item, ListOptions listOptions, final Watcher<ServiceRoleBinding> watcher) {
return new ServiceRoleBindingOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public ServiceRoleBinding waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceRoleBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new ServiceRoleBindingOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public ServiceRoleBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceRoleBinding item, Predicate<ServiceRoleBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceRoleBindingOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
