
package me.snowdrop.istio.client.internal.operation.policy.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.api.policy.v1beta1.DoneableInstance;
import me.snowdrop.istio.api.policy.v1beta1.Instance;
import me.snowdrop.istio.api.policy.v1beta1.InstanceList;
import me.snowdrop.istio.api.policy.v1beta1.DoneableInstance;

import java.util.Map;
import java.util.TreeMap;


public class InstanceOperationImpl extends HasMetadataOperation<Instance, InstanceList, DoneableInstance, Resource<Instance, DoneableInstance>> {

  public InstanceOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public InstanceOperationImpl(OperationContext context) {
    super(context.withApiGroupName("config.istio.io")
      .withApiGroupVersion("v1alpha2")
      .withPlural("instances"));
    this.type = Instance.class;
    this.listType = InstanceList.class;
    this.doneableType = DoneableInstance.class;
}

  public InstanceOperationImpl newInstance(OperationContext context) {
    return new InstanceOperationImpl(context);
  }
}
