
package me.snowdrop.istio.client.internal.operation.security.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.api.security.v1beta1.DoneablePeerAuthentication;
import me.snowdrop.istio.api.security.v1beta1.PeerAuthentication;
import me.snowdrop.istio.api.security.v1beta1.PeerAuthenticationList;
import me.snowdrop.istio.api.security.v1beta1.DoneablePeerAuthentication;

import java.util.Map;
import java.util.TreeMap;


public class PeerAuthenticationOperationImpl extends HasMetadataOperation<PeerAuthentication, PeerAuthenticationList, DoneablePeerAuthentication, Resource<PeerAuthentication, DoneablePeerAuthentication>> {

  public PeerAuthenticationOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public PeerAuthenticationOperationImpl(OperationContext context) {
    super(context.withApiGroupName("security.istio.io")
      .withApiGroupVersion("v1beta1")
      .withPlural("peerauthentications"));
    this.type = PeerAuthentication.class;
    this.listType = PeerAuthenticationList.class;
    this.doneableType = DoneablePeerAuthentication.class;
}

  public PeerAuthenticationOperationImpl newInstance(OperationContext context) {
    return new PeerAuthenticationOperationImpl(context);
  }
}
