
package me.snowdrop.istio.client.internal.handler.networking.v1alpha3;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.networking.v1alpha3.WorkloadEntryOperationImpl;

import me.snowdrop.istio.api.networking.v1alpha3.WorkloadEntry;
import me.snowdrop.istio.api.networking.v1alpha3.WorkloadEntryBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class WorkloadEntryHandler implements ResourceHandler<WorkloadEntry, WorkloadEntryBuilder> {

  @Override
  public String getKind() {
    return WorkloadEntry.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "networking.istio.io/v1alpha3";
    }

  @Override
public WorkloadEntry create(OkHttpClient client, Config config, String namespace, WorkloadEntry item) {
return new WorkloadEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public WorkloadEntry replace(OkHttpClient client, Config config, String namespace, WorkloadEntry item) {
return new WorkloadEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public WorkloadEntry reload(OkHttpClient client, Config config, String namespace, WorkloadEntry item) {
return new WorkloadEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public WorkloadEntryBuilder edit(WorkloadEntry item) {
return new WorkloadEntryBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, WorkloadEntry item) {
return new WorkloadEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, WorkloadEntry item, Watcher<WorkloadEntry> watcher) {
return new WorkloadEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, WorkloadEntry item, String resourceVersion, Watcher<WorkloadEntry> watcher) {
return new WorkloadEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, WorkloadEntry item, ListOptions listOptions, final Watcher<WorkloadEntry> watcher) {
return new WorkloadEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public WorkloadEntry waitUntilReady(OkHttpClient client, Config config, String namespace, WorkloadEntry item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new WorkloadEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public WorkloadEntry waitUntilCondition(OkHttpClient client, Config config, String namespace, WorkloadEntry item, Predicate<WorkloadEntry> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new WorkloadEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
