
package me.snowdrop.istio.client.internal.handler.networking.v1beta1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.networking.v1beta1.GatewayOperationImpl;

import me.snowdrop.istio.api.networking.v1beta1.Gateway;
import me.snowdrop.istio.api.networking.v1beta1.GatewayBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class GatewayHandler implements ResourceHandler<Gateway, GatewayBuilder> {

  @Override
  public String getKind() {
    return Gateway.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "networking.istio.io/v1beta1";
    }

  @Override
public Gateway create(OkHttpClient client, Config config, String namespace, Gateway item) {
return new GatewayOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public Gateway replace(OkHttpClient client, Config config, String namespace, Gateway item) {
return new GatewayOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public Gateway reload(OkHttpClient client, Config config, String namespace, Gateway item) {
return new GatewayOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public GatewayBuilder edit(Gateway item) {
return new GatewayBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Gateway item) {
return new GatewayOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Gateway item, Watcher<Gateway> watcher) {
return new GatewayOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Gateway item, String resourceVersion, Watcher<Gateway> watcher) {
return new GatewayOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Gateway item, ListOptions listOptions, final Watcher<Gateway> watcher) {
return new GatewayOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public Gateway waitUntilReady(OkHttpClient client, Config config, String namespace, Gateway item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new GatewayOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public Gateway waitUntilCondition(OkHttpClient client, Config config, String namespace, Gateway item, Predicate<Gateway> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GatewayOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
