
package me.snowdrop.istio.client.internal.handler.policy.v1beta1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.policy.v1beta1.HandlerOperationImpl;

import me.snowdrop.istio.api.policy.v1beta1.Handler;
import me.snowdrop.istio.api.policy.v1beta1.HandlerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class HandlerHandler implements ResourceHandler<Handler, HandlerBuilder> {

  @Override
  public String getKind() {
    return Handler.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.istio.io/v1alpha2";
    }

  @Override
public Handler create(OkHttpClient client, Config config, String namespace, Handler item) {
return new HandlerOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public Handler replace(OkHttpClient client, Config config, String namespace, Handler item) {
return new HandlerOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public Handler reload(OkHttpClient client, Config config, String namespace, Handler item) {
return new HandlerOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public HandlerBuilder edit(Handler item) {
return new HandlerBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Handler item) {
return new HandlerOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Handler item, Watcher<Handler> watcher) {
return new HandlerOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Handler item, String resourceVersion, Watcher<Handler> watcher) {
return new HandlerOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Handler item, ListOptions listOptions, final Watcher<Handler> watcher) {
return new HandlerOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public Handler waitUntilReady(OkHttpClient client, Config config, String namespace, Handler item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new HandlerOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public Handler waitUntilCondition(OkHttpClient client, Config config, String namespace, Handler item, Predicate<Handler> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new HandlerOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
