
package me.snowdrop.istio.client.internal.handler.security.v1beta1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.security.v1beta1.PeerAuthenticationOperationImpl;

import me.snowdrop.istio.api.security.v1beta1.PeerAuthentication;
import me.snowdrop.istio.api.security.v1beta1.PeerAuthenticationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class PeerAuthenticationHandler implements ResourceHandler<PeerAuthentication, PeerAuthenticationBuilder> {

  @Override
  public String getKind() {
    return PeerAuthentication.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "security.istio.io/v1beta1";
    }

  @Override
public PeerAuthentication create(OkHttpClient client, Config config, String namespace, PeerAuthentication item) {
return new PeerAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public PeerAuthentication replace(OkHttpClient client, Config config, String namespace, PeerAuthentication item) {
return new PeerAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public PeerAuthentication reload(OkHttpClient client, Config config, String namespace, PeerAuthentication item) {
return new PeerAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public PeerAuthenticationBuilder edit(PeerAuthentication item) {
return new PeerAuthenticationBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, PeerAuthentication item) {
return new PeerAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, PeerAuthentication item, Watcher<PeerAuthentication> watcher) {
return new PeerAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, PeerAuthentication item, String resourceVersion, Watcher<PeerAuthentication> watcher) {
return new PeerAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, PeerAuthentication item, ListOptions listOptions, final Watcher<PeerAuthentication> watcher) {
return new PeerAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public PeerAuthentication waitUntilReady(OkHttpClient client, Config config, String namespace, PeerAuthentication item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new PeerAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public PeerAuthentication waitUntilCondition(OkHttpClient client, Config config, String namespace, PeerAuthentication item, Predicate<PeerAuthentication> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PeerAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
