
package me.snowdrop.istio.client.internal.operation.networking.v1alpha3;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.api.networking.v1alpha3.VirtualService;
import me.snowdrop.istio.api.networking.v1alpha3.VirtualServiceList;

import java.util.Map;
import java.util.TreeMap;


public class VirtualServiceOperationImpl extends HasMetadataOperation<VirtualService, VirtualServiceList, Resource<VirtualService>> {

  public VirtualServiceOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public VirtualServiceOperationImpl(OperationContext context) {
    super(context.withApiGroupName("networking.istio.io")
      .withApiGroupVersion("v1alpha3")
      .withPlural("virtualservices"));
    this.type = VirtualService.class;
    this.listType = VirtualServiceList.class;
}

  public VirtualServiceOperationImpl newInstance(OperationContext context) {
    return new VirtualServiceOperationImpl(context);
  }
}
