
package me.snowdrop.istio.client.internal.operation.security.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.api.security.v1beta1.AuthorizationPolicy;
import me.snowdrop.istio.api.security.v1beta1.AuthorizationPolicyList;

import java.util.Map;
import java.util.TreeMap;


public class AuthorizationPolicyOperationImpl extends HasMetadataOperation<AuthorizationPolicy, AuthorizationPolicyList, Resource<AuthorizationPolicy>> {

  public AuthorizationPolicyOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public AuthorizationPolicyOperationImpl(OperationContext context) {
    super(context.withApiGroupName("security.istio.io")
      .withApiGroupVersion("v1beta1")
      .withPlural("authorizationpolicies"));
    this.type = AuthorizationPolicy.class;
    this.listType = AuthorizationPolicyList.class;
}

  public AuthorizationPolicyOperationImpl newInstance(OperationContext context) {
    return new AuthorizationPolicyOperationImpl(context);
  }
}
