/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import me.snowdrop.istio.api.mesh.v1alpha1.SDS;
import me.snowdrop.istio.api.mesh.v1alpha1.SDSFluent;
import me.snowdrop.istio.api.mesh.v1alpha1.SDSFluentImpl;

public class SDSBuilder
extends SDSFluentImpl<SDSBuilder>
implements VisitableBuilder<SDS, SDSBuilder> {
    SDSFluent<?> fluent;
    Boolean validationEnabled;

    public SDSBuilder() {
        this(true);
    }

    public SDSBuilder(Boolean validationEnabled) {
        this(new SDS(), validationEnabled);
    }

    public SDSBuilder(SDSFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SDSBuilder(SDSFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SDS(), validationEnabled);
    }

    public SDSBuilder(SDSFluent<?> fluent, SDS instance) {
        this(fluent, instance, true);
    }

    public SDSBuilder(SDSFluent<?> fluent, SDS instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEnabled(instance.getEnabled());
        fluent.withK8sSaJwtPath(instance.getK8sSaJwtPath());
        this.validationEnabled = validationEnabled;
    }

    public SDSBuilder(SDS instance) {
        this(instance, (Boolean)true);
    }

    public SDSBuilder(SDS instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEnabled(instance.getEnabled());
        this.withK8sSaJwtPath(instance.getK8sSaJwtPath());
        this.validationEnabled = validationEnabled;
    }

    public SDS build() {
        SDS buildable = new SDS(this.fluent.isEnabled(), this.fluent.getK8sSaJwtPath());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SDSBuilder that = (SDSBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

