/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.networking.v1alpha3.Port;
import me.snowdrop.istio.api.networking.v1alpha3.PortBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.PortFluentImpl;
import me.snowdrop.istio.api.networking.v1alpha3.Server;
import me.snowdrop.istio.api.networking.v1alpha3.ServerFluent;
import me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettings;
import me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.ServerTLSSettingsFluentImpl;

public class ServerFluentImpl<A extends ServerFluent<A>>
extends BaseFluent<A>
implements ServerFluent<A> {
    private String bind;
    private String defaultEndpoint;
    private List<String> hosts;
    private String name;
    private PortBuilder port;
    private ServerTLSSettingsBuilder tls;

    public ServerFluentImpl() {
    }

    public ServerFluentImpl(Server instance) {
        this.withBind(instance.getBind());
        this.withDefaultEndpoint(instance.getDefaultEndpoint());
        this.withHosts(instance.getHosts());
        this.withName(instance.getName());
        this.withPort(instance.getPort());
        this.withTls(instance.getTls());
    }

    @Override
    public String getBind() {
        return this.bind;
    }

    @Override
    public A withBind(String bind) {
        this.bind = bind;
        return (A)this;
    }

    @Override
    public Boolean hasBind() {
        return this.bind != null;
    }

    @Override
    public A withNewBind(String arg1) {
        return this.withBind(new String(arg1));
    }

    @Override
    public A withNewBind(StringBuilder arg1) {
        return this.withBind(new String(arg1));
    }

    @Override
    public A withNewBind(StringBuffer arg1) {
        return this.withBind(new String(arg1));
    }

    @Override
    public String getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    @Override
    public A withDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultEndpoint() {
        return this.defaultEndpoint != null;
    }

    @Override
    public A withNewDefaultEndpoint(String arg1) {
        return this.withDefaultEndpoint(new String(arg1));
    }

    @Override
    public A withNewDefaultEndpoint(StringBuilder arg1) {
        return this.withDefaultEndpoint(new String(arg1));
    }

    @Override
    public A withNewDefaultEndpoint(StringBuffer arg1) {
        return this.withDefaultEndpoint(new String(arg1));
    }

    @Override
    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<String> items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public String getHost(int index) {
        return this.hosts.get(index);
    }

    @Override
    public String getFirstHost() {
        return this.hosts.get(0);
    }

    @Override
    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHosts(List<String> hosts) {
        if (this.hosts != null) {
            this._visitables.get((Object)"hosts").removeAll(this.hosts);
        }
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public A addNewHost(String arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuilder arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuffer arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    @Deprecated
    public Port getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public Port buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(Port port) {
        this._visitables.get((Object)"port").remove(this.port);
        if (port != null) {
            this.port = new PortBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(String name, Integer number, String protocol, Integer targetPort) {
        return this.withPort(new Port(name, number, protocol, targetPort));
    }

    @Override
    public ServerFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public ServerFluent.PortNested<A> withNewPortLike(Port item) {
        return new PortNestedImpl(item);
    }

    @Override
    public ServerFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public ServerFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new PortBuilder().build());
    }

    @Override
    public ServerFluent.PortNested<A> editOrNewPortLike(Port item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    @Deprecated
    public ServerTLSSettings getTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public ServerTLSSettings buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public A withTls(ServerTLSSettings tls) {
        this._visitables.get((Object)"tls").remove(this.tls);
        if (tls != null) {
            this.tls = new ServerTLSSettingsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null;
    }

    @Override
    public ServerFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public ServerFluent.TlsNested<A> withNewTlsLike(ServerTLSSettings item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public ServerFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public ServerFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new ServerTLSSettingsBuilder().build());
    }

    @Override
    public ServerFluent.TlsNested<A> editOrNewTlsLike(ServerTLSSettings item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerFluentImpl that = (ServerFluentImpl)o;
        if (this.bind != null ? !this.bind.equals(that.bind) : that.bind != null) {
            return false;
        }
        if (this.defaultEndpoint != null ? !this.defaultEndpoint.equals(that.defaultEndpoint) : that.defaultEndpoint != null) {
            return false;
        }
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        return !(this.tls != null ? !this.tls.equals(that.tls) : that.tls != null);
    }

    public class TlsNestedImpl<N>
    extends ServerTLSSettingsFluentImpl<ServerFluent.TlsNested<N>>
    implements ServerFluent.TlsNested<N>,
    Nested<N> {
        private final ServerTLSSettingsBuilder builder;

        TlsNestedImpl(ServerTLSSettings item) {
            this.builder = new ServerTLSSettingsBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new ServerTLSSettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServerFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }

    public class PortNestedImpl<N>
    extends PortFluentImpl<ServerFluent.PortNested<N>>
    implements ServerFluent.PortNested<N>,
    Nested<N> {
        private final PortBuilder builder;

        PortNestedImpl(Port item) {
            this.builder = new PortBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new PortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServerFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

