/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.dogstatsd;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import me.snowdrop.istio.mixer.adapter.dogstatsd.Dogstatsd;
import me.snowdrop.istio.mixer.adapter.dogstatsd.DogstatsdFluent;
import me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo;

public class DogstatsdFluentImpl<A extends DogstatsdFluent<A>>
extends BaseFluent<A>
implements DogstatsdFluent<A> {
    private String address;
    private Integer bufferLength;
    private Map<String, String> globalTags;
    private Map<String, MetricInfo> metrics;
    private String prefix;
    private Double sampleRate;

    public DogstatsdFluentImpl() {
    }

    public DogstatsdFluentImpl(Dogstatsd instance) {
        this.withAddress(instance.getAddress());
        this.withBufferLength(instance.getBufferLength());
        this.withGlobalTags(instance.getGlobalTags());
        this.withMetrics(instance.getMetrics());
        this.withPrefix(instance.getPrefix());
        this.withSampleRate(instance.getSampleRate());
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public A withAddress(String address) {
        this.address = address;
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A withNewAddress(String arg1) {
        return this.withAddress(new String(arg1));
    }

    @Override
    public A withNewAddress(StringBuilder arg1) {
        return this.withAddress(new String(arg1));
    }

    @Override
    public A withNewAddress(StringBuffer arg1) {
        return this.withAddress(new String(arg1));
    }

    @Override
    public Integer getBufferLength() {
        return this.bufferLength;
    }

    @Override
    public A withBufferLength(Integer bufferLength) {
        this.bufferLength = bufferLength;
        return (A)this;
    }

    @Override
    public Boolean hasBufferLength() {
        return this.bufferLength != null;
    }

    @Override
    public A addToGlobalTags(String key, String value) {
        if (this.globalTags == null && key != null && value != null) {
            this.globalTags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.globalTags.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToGlobalTags(Map<String, String> map) {
        if (this.globalTags == null && map != null) {
            this.globalTags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.globalTags.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromGlobalTags(String key) {
        if (this.globalTags == null) {
            return (A)this;
        }
        if (key != null && this.globalTags != null) {
            this.globalTags.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromGlobalTags(Map<String, String> map) {
        if (this.globalTags == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.globalTags == null) continue;
                this.globalTags.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getGlobalTags() {
        return this.globalTags;
    }

    @Override
    public A withGlobalTags(Map<String, String> globalTags) {
        this.globalTags = globalTags == null ? null : new LinkedHashMap<String, String>(globalTags);
        return (A)this;
    }

    @Override
    public Boolean hasGlobalTags() {
        return this.globalTags != null;
    }

    @Override
    public A addToMetrics(String key, MetricInfo value) {
        if (this.metrics == null && key != null && value != null) {
            this.metrics = new LinkedHashMap<String, MetricInfo>();
        }
        if (key != null && value != null) {
            this.metrics.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(Map<String, MetricInfo> map) {
        if (this.metrics == null && map != null) {
            this.metrics = new LinkedHashMap<String, MetricInfo>();
        }
        if (map != null) {
            this.metrics.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(String key) {
        if (this.metrics == null) {
            return (A)this;
        }
        if (key != null && this.metrics != null) {
            this.metrics.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(Map<String, MetricInfo> map) {
        if (this.metrics == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metrics == null) continue;
                this.metrics.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, MetricInfo> getMetrics() {
        return this.metrics;
    }

    @Override
    public A withMetrics(Map<String, MetricInfo> metrics) {
        this.metrics = metrics == null ? null : new LinkedHashMap<String, MetricInfo>(metrics);
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public A withPrefix(String prefix) {
        this.prefix = prefix;
        return (A)this;
    }

    @Override
    public Boolean hasPrefix() {
        return this.prefix != null;
    }

    @Override
    public A withNewPrefix(String arg1) {
        return this.withPrefix(new String(arg1));
    }

    @Override
    public A withNewPrefix(StringBuilder arg1) {
        return this.withPrefix(new String(arg1));
    }

    @Override
    public A withNewPrefix(StringBuffer arg1) {
        return this.withPrefix(new String(arg1));
    }

    @Override
    public Double getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public A withSampleRate(Double sampleRate) {
        this.sampleRate = sampleRate;
        return (A)this;
    }

    @Override
    public Boolean hasSampleRate() {
        return this.sampleRate != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DogstatsdFluentImpl that = (DogstatsdFluentImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.bufferLength != null ? !this.bufferLength.equals(that.bufferLength) : that.bufferLength != null) {
            return false;
        }
        if (this.globalTags != null ? !this.globalTags.equals(that.globalTags) : that.globalTags != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) {
            return false;
        }
        return !(this.sampleRate != null ? !this.sampleRate.equals(that.sampleRate) : that.sampleRate != null);
    }
}

