
package me.snowdrop.istio.api;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "typeUrl",
    "value"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Any implements Serializable
{

    /**
     * 
     */
    @JsonProperty("typeUrl")
    @JsonPropertyDescription("")
    private String typeUrl;
    /**
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("")
    private String value;
    private final static long serialVersionUID = 2384147917044359682L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Any() {
    }

    /**
     * 
     * @param typeUrl
     * @param value
     */
    public Any(String typeUrl, String value) {
        super();
        this.typeUrl = typeUrl;
        this.value = value;
    }

    /**
     * 
     */
    public String getTypeUrl() {
        return typeUrl;
    }

    /**
     * 
     */
    public void setTypeUrl(String typeUrl) {
        this.typeUrl = typeUrl;
    }

    /**
     * 
     */
    public String getValue() {
        return value;
    }

    /**
     * 
     */
    public void setValue(String value) {
        this.value = value;
    }

}
